<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AuthenticationCredentials StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos de autenticación para el uso del WebService Servivuelo
 * - nillable: true
 * - type: tns:AuthenticationCredentials
 * @subpackage Structs
 */
class AuthenticationCredentials extends AbstractStructBase
{
    /**
     * The AgencyID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la agencia
     * @var int
     */
    public $AgencyID;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del usuario
     * @var int
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - documentation: Password de autenticación
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * Constructor method for AuthenticationCredentials
     * @uses AuthenticationCredentials::setAgencyID()
     * @uses AuthenticationCredentials::setUserID()
     * @uses AuthenticationCredentials::setPassword()
     * @param int $agencyID
     * @param int $userID
     * @param string $password
     */
    public function __construct($agencyID = null, $userID = null, $password = null)
    {
        $this
            ->setAgencyID($agencyID)
            ->setUserID($userID)
            ->setPassword($password);
    }
    /**
     * Get AgencyID value
     * @return int|null
     */
    public function getAgencyID()
    {
        return $this->AgencyID;
    }
    /**
     * Set AgencyID value
     * @param int $agencyID
     * @return \StructType\AuthenticationCredentials
     */
    public function setAgencyID($agencyID = null)
    {
        // validation for constraint: int
        if (!is_null($agencyID) && !(is_int($agencyID) || ctype_digit($agencyID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agencyID, true), gettype($agencyID)), __LINE__);
        }
        $this->AgencyID = $agencyID;
        return $this;
    }
    /**
     * Get UserID value
     * @return int|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param int $userID
     * @return \StructType\AuthenticationCredentials
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: int
        if (!is_null($userID) && !(is_int($userID) || ctype_digit($userID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\AuthenticationCredentials
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
}
