<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTravelerTSAData StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con los datos TSA de un pasajero, que vuela a paises donde es obligatorio informar sobre datos extra (ej.EEUU)
 * - nillable: true
 * - type: tns:AirTravelerTSAData
 * @subpackage Structs
 */
class AirTravelerTSAData extends AbstractStructBase
{
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Nombre del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Apellidos del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - documentation: Genero del pasajero (<b>M</b>: Male, <b>F</b>: Female, <b>MI</b>: Male Infant, <b>FI</b>: Female Infant, <b>U</b>: Undisclosed Gender)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The BirthDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de nacimiento (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthDate;
    /**
     * The DocumentExpirationDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de caducidad del documento de identidad (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentExpirationDate;
    /**
     * The DocumentIssueCountry
     * Meta information extracted from the WSDL
     * - documentation: Código del país de emisión del documento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentIssueCountry;
    /**
     * The DocumentType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de documento (<b>I</b>: Documento Nacional de Identidad, <b>P</b>: Pasaporte, <b>IP</b>: Tarjeta de residente o tarjeta pasaporte, <b>A</b>: Otra tarjeta de identidad, <b>AC</b>: Certificado de miembro de tripulacion, <b>F</b>:
     * Cartilla verde americana)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentNumber
     * Meta information extracted from the WSDL
     * - documentation: Numero de documento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentNumber;
    /**
     * The BirthCountry
     * Meta information extracted from the WSDL
     * - documentation: Código del país de nacimiento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BirthCountry;
    /**
     * The NationalityCountry
     * Meta information extracted from the WSDL
     * - documentation: Código del país de nacionalidad
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NationalityCountry;
    /**
     * The VisaIssueCity
     * Meta information extracted from the WSDL
     * - documentation: Ciudad de emisión del visado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisaIssueCity;
    /**
     * The VisaNumber
     * Meta information extracted from the WSDL
     * - documentation: Número de visado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisaNumber;
    /**
     * The VisaIssueCountry
     * Meta information extracted from the WSDL
     * - documentation: Código del país de emisión del visado
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisaIssueCountry;
    /**
     * The VisaIssueDate
     * Meta information extracted from the WSDL
     * - documentation: Fecha de emisión del visado (formato dd/MM/aaaa)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisaIssueDate;
    /**
     * The IsResidentUSA
     * Meta information extracted from the WSDL
     * - documentation: Booleano que indica si el pasajero es residente en Estados Unidos
     * - minOccurs: 0
     * @var bool
     */
    public $IsResidentUSA;
    /**
     * The USA_City
     * Meta information extracted from the WSDL
     * - documentation: Ciudad de la dirección en Estados Unidos
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $USA_City;
    /**
     * The USA_State
     * Meta information extracted from the WSDL
     * - documentation: Código del estado/provincia de la dirección en Estados Unidos
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $USA_State;
    /**
     * The USA_ResidenceType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de residencia en Estados Unidos (<b>D</b>: en el destino, <b>R</b>: residencia)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $USA_ResidenceType;
    /**
     * The USA_Address
     * Meta information extracted from the WSDL
     * - documentation: Calle de la dirección en estados unidos
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $USA_Address;
    /**
     * The USA_ZipCode
     * Meta information extracted from the WSDL
     * - documentation: Código postal de la dirección en Estados Unidos
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $USA_ZipCode;
    /**
     * Constructor method for AirTravelerTSAData
     * @uses AirTravelerTSAData::setFirstName()
     * @uses AirTravelerTSAData::setLastName()
     * @uses AirTravelerTSAData::setGender()
     * @uses AirTravelerTSAData::setBirthDate()
     * @uses AirTravelerTSAData::setDocumentExpirationDate()
     * @uses AirTravelerTSAData::setDocumentIssueCountry()
     * @uses AirTravelerTSAData::setDocumentType()
     * @uses AirTravelerTSAData::setDocumentNumber()
     * @uses AirTravelerTSAData::setBirthCountry()
     * @uses AirTravelerTSAData::setNationalityCountry()
     * @uses AirTravelerTSAData::setVisaIssueCity()
     * @uses AirTravelerTSAData::setVisaNumber()
     * @uses AirTravelerTSAData::setVisaIssueCountry()
     * @uses AirTravelerTSAData::setVisaIssueDate()
     * @uses AirTravelerTSAData::setIsResidentUSA()
     * @uses AirTravelerTSAData::setUSA_City()
     * @uses AirTravelerTSAData::setUSA_State()
     * @uses AirTravelerTSAData::setUSA_ResidenceType()
     * @uses AirTravelerTSAData::setUSA_Address()
     * @uses AirTravelerTSAData::setUSA_ZipCode()
     * @param string $firstName
     * @param string $lastName
     * @param string $gender
     * @param string $birthDate
     * @param string $documentExpirationDate
     * @param string $documentIssueCountry
     * @param string $documentType
     * @param string $documentNumber
     * @param string $birthCountry
     * @param string $nationalityCountry
     * @param string $visaIssueCity
     * @param string $visaNumber
     * @param string $visaIssueCountry
     * @param string $visaIssueDate
     * @param bool $isResidentUSA
     * @param string $uSA_City
     * @param string $uSA_State
     * @param string $uSA_ResidenceType
     * @param string $uSA_Address
     * @param string $uSA_ZipCode
     */
    public function __construct($firstName = null, $lastName = null, $gender = null, $birthDate = null, $documentExpirationDate = null, $documentIssueCountry = null, $documentType = null, $documentNumber = null, $birthCountry = null, $nationalityCountry = null, $visaIssueCity = null, $visaNumber = null, $visaIssueCountry = null, $visaIssueDate = null, $isResidentUSA = null, $uSA_City = null, $uSA_State = null, $uSA_ResidenceType = null, $uSA_Address = null, $uSA_ZipCode = null)
    {
        $this
            ->setFirstName($firstName)
            ->setLastName($lastName)
            ->setGender($gender)
            ->setBirthDate($birthDate)
            ->setDocumentExpirationDate($documentExpirationDate)
            ->setDocumentIssueCountry($documentIssueCountry)
            ->setDocumentType($documentType)
            ->setDocumentNumber($documentNumber)
            ->setBirthCountry($birthCountry)
            ->setNationalityCountry($nationalityCountry)
            ->setVisaIssueCity($visaIssueCity)
            ->setVisaNumber($visaNumber)
            ->setVisaIssueCountry($visaIssueCountry)
            ->setVisaIssueDate($visaIssueDate)
            ->setIsResidentUSA($isResidentUSA)
            ->setUSA_City($uSA_City)
            ->setUSA_State($uSA_State)
            ->setUSA_ResidenceType($uSA_ResidenceType)
            ->setUSA_Address($uSA_Address)
            ->setUSA_ZipCode($uSA_ZipCode);
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \StructType\AirTravelerTSAData
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \StructType\AirTravelerTSAData
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gender
     * @return \StructType\AirTravelerTSAData
     */
    public function setGender($gender = null)
    {
        // validation for constraint: string
        if (!is_null($gender) && !is_string($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gender, true), gettype($gender)), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get BirthDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthDate()
    {
        return isset($this->BirthDate) ? $this->BirthDate : null;
    }
    /**
     * Set BirthDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthDate
     * @return \StructType\AirTravelerTSAData
     */
    public function setBirthDate($birthDate = null)
    {
        // validation for constraint: string
        if (!is_null($birthDate) && !is_string($birthDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthDate, true), gettype($birthDate)), __LINE__);
        }
        if (is_null($birthDate) || (is_array($birthDate) && empty($birthDate))) {
            unset($this->BirthDate);
        } else {
            $this->BirthDate = $birthDate;
        }
        return $this;
    }
    /**
     * Get DocumentExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentExpirationDate()
    {
        return isset($this->DocumentExpirationDate) ? $this->DocumentExpirationDate : null;
    }
    /**
     * Set DocumentExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentExpirationDate
     * @return \StructType\AirTravelerTSAData
     */
    public function setDocumentExpirationDate($documentExpirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentExpirationDate) && !is_string($documentExpirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentExpirationDate, true), gettype($documentExpirationDate)), __LINE__);
        }
        if (is_null($documentExpirationDate) || (is_array($documentExpirationDate) && empty($documentExpirationDate))) {
            unset($this->DocumentExpirationDate);
        } else {
            $this->DocumentExpirationDate = $documentExpirationDate;
        }
        return $this;
    }
    /**
     * Get DocumentIssueCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentIssueCountry()
    {
        return isset($this->DocumentIssueCountry) ? $this->DocumentIssueCountry : null;
    }
    /**
     * Set DocumentIssueCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentIssueCountry
     * @return \StructType\AirTravelerTSAData
     */
    public function setDocumentIssueCountry($documentIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($documentIssueCountry) && !is_string($documentIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentIssueCountry, true), gettype($documentIssueCountry)), __LINE__);
        }
        if (is_null($documentIssueCountry) || (is_array($documentIssueCountry) && empty($documentIssueCountry))) {
            unset($this->DocumentIssueCountry);
        } else {
            $this->DocumentIssueCountry = $documentIssueCountry;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentType
     * @return \StructType\AirTravelerTSAData
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get DocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return isset($this->DocumentNumber) ? $this->DocumentNumber : null;
    }
    /**
     * Set DocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentNumber
     * @return \StructType\AirTravelerTSAData
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($documentNumber) && !is_string($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentNumber, true), gettype($documentNumber)), __LINE__);
        }
        if (is_null($documentNumber) || (is_array($documentNumber) && empty($documentNumber))) {
            unset($this->DocumentNumber);
        } else {
            $this->DocumentNumber = $documentNumber;
        }
        return $this;
    }
    /**
     * Get BirthCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBirthCountry()
    {
        return isset($this->BirthCountry) ? $this->BirthCountry : null;
    }
    /**
     * Set BirthCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $birthCountry
     * @return \StructType\AirTravelerTSAData
     */
    public function setBirthCountry($birthCountry = null)
    {
        // validation for constraint: string
        if (!is_null($birthCountry) && !is_string($birthCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthCountry, true), gettype($birthCountry)), __LINE__);
        }
        if (is_null($birthCountry) || (is_array($birthCountry) && empty($birthCountry))) {
            unset($this->BirthCountry);
        } else {
            $this->BirthCountry = $birthCountry;
        }
        return $this;
    }
    /**
     * Get NationalityCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNationalityCountry()
    {
        return isset($this->NationalityCountry) ? $this->NationalityCountry : null;
    }
    /**
     * Set NationalityCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nationalityCountry
     * @return \StructType\AirTravelerTSAData
     */
    public function setNationalityCountry($nationalityCountry = null)
    {
        // validation for constraint: string
        if (!is_null($nationalityCountry) && !is_string($nationalityCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nationalityCountry, true), gettype($nationalityCountry)), __LINE__);
        }
        if (is_null($nationalityCountry) || (is_array($nationalityCountry) && empty($nationalityCountry))) {
            unset($this->NationalityCountry);
        } else {
            $this->NationalityCountry = $nationalityCountry;
        }
        return $this;
    }
    /**
     * Get VisaIssueCity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisaIssueCity()
    {
        return isset($this->VisaIssueCity) ? $this->VisaIssueCity : null;
    }
    /**
     * Set VisaIssueCity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visaIssueCity
     * @return \StructType\AirTravelerTSAData
     */
    public function setVisaIssueCity($visaIssueCity = null)
    {
        // validation for constraint: string
        if (!is_null($visaIssueCity) && !is_string($visaIssueCity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaIssueCity, true), gettype($visaIssueCity)), __LINE__);
        }
        if (is_null($visaIssueCity) || (is_array($visaIssueCity) && empty($visaIssueCity))) {
            unset($this->VisaIssueCity);
        } else {
            $this->VisaIssueCity = $visaIssueCity;
        }
        return $this;
    }
    /**
     * Get VisaNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisaNumber()
    {
        return isset($this->VisaNumber) ? $this->VisaNumber : null;
    }
    /**
     * Set VisaNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visaNumber
     * @return \StructType\AirTravelerTSAData
     */
    public function setVisaNumber($visaNumber = null)
    {
        // validation for constraint: string
        if (!is_null($visaNumber) && !is_string($visaNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaNumber, true), gettype($visaNumber)), __LINE__);
        }
        if (is_null($visaNumber) || (is_array($visaNumber) && empty($visaNumber))) {
            unset($this->VisaNumber);
        } else {
            $this->VisaNumber = $visaNumber;
        }
        return $this;
    }
    /**
     * Get VisaIssueCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisaIssueCountry()
    {
        return isset($this->VisaIssueCountry) ? $this->VisaIssueCountry : null;
    }
    /**
     * Set VisaIssueCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visaIssueCountry
     * @return \StructType\AirTravelerTSAData
     */
    public function setVisaIssueCountry($visaIssueCountry = null)
    {
        // validation for constraint: string
        if (!is_null($visaIssueCountry) && !is_string($visaIssueCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaIssueCountry, true), gettype($visaIssueCountry)), __LINE__);
        }
        if (is_null($visaIssueCountry) || (is_array($visaIssueCountry) && empty($visaIssueCountry))) {
            unset($this->VisaIssueCountry);
        } else {
            $this->VisaIssueCountry = $visaIssueCountry;
        }
        return $this;
    }
    /**
     * Get VisaIssueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisaIssueDate()
    {
        return isset($this->VisaIssueDate) ? $this->VisaIssueDate : null;
    }
    /**
     * Set VisaIssueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visaIssueDate
     * @return \StructType\AirTravelerTSAData
     */
    public function setVisaIssueDate($visaIssueDate = null)
    {
        // validation for constraint: string
        if (!is_null($visaIssueDate) && !is_string($visaIssueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visaIssueDate, true), gettype($visaIssueDate)), __LINE__);
        }
        if (is_null($visaIssueDate) || (is_array($visaIssueDate) && empty($visaIssueDate))) {
            unset($this->VisaIssueDate);
        } else {
            $this->VisaIssueDate = $visaIssueDate;
        }
        return $this;
    }
    /**
     * Get IsResidentUSA value
     * @return bool|null
     */
    public function getIsResidentUSA()
    {
        return $this->IsResidentUSA;
    }
    /**
     * Set IsResidentUSA value
     * @param bool $isResidentUSA
     * @return \StructType\AirTravelerTSAData
     */
    public function setIsResidentUSA($isResidentUSA = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResidentUSA) && !is_bool($isResidentUSA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResidentUSA, true), gettype($isResidentUSA)), __LINE__);
        }
        $this->IsResidentUSA = $isResidentUSA;
        return $this;
    }
    /**
     * Get USA_City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUSA_City()
    {
        return isset($this->USA_City) ? $this->USA_City : null;
    }
    /**
     * Set USA_City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uSA_City
     * @return \StructType\AirTravelerTSAData
     */
    public function setUSA_City($uSA_City = null)
    {
        // validation for constraint: string
        if (!is_null($uSA_City) && !is_string($uSA_City)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSA_City, true), gettype($uSA_City)), __LINE__);
        }
        if (is_null($uSA_City) || (is_array($uSA_City) && empty($uSA_City))) {
            unset($this->USA_City);
        } else {
            $this->USA_City = $uSA_City;
        }
        return $this;
    }
    /**
     * Get USA_State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUSA_State()
    {
        return isset($this->USA_State) ? $this->USA_State : null;
    }
    /**
     * Set USA_State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uSA_State
     * @return \StructType\AirTravelerTSAData
     */
    public function setUSA_State($uSA_State = null)
    {
        // validation for constraint: string
        if (!is_null($uSA_State) && !is_string($uSA_State)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSA_State, true), gettype($uSA_State)), __LINE__);
        }
        if (is_null($uSA_State) || (is_array($uSA_State) && empty($uSA_State))) {
            unset($this->USA_State);
        } else {
            $this->USA_State = $uSA_State;
        }
        return $this;
    }
    /**
     * Get USA_ResidenceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUSA_ResidenceType()
    {
        return isset($this->USA_ResidenceType) ? $this->USA_ResidenceType : null;
    }
    /**
     * Set USA_ResidenceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uSA_ResidenceType
     * @return \StructType\AirTravelerTSAData
     */
    public function setUSA_ResidenceType($uSA_ResidenceType = null)
    {
        // validation for constraint: string
        if (!is_null($uSA_ResidenceType) && !is_string($uSA_ResidenceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSA_ResidenceType, true), gettype($uSA_ResidenceType)), __LINE__);
        }
        if (is_null($uSA_ResidenceType) || (is_array($uSA_ResidenceType) && empty($uSA_ResidenceType))) {
            unset($this->USA_ResidenceType);
        } else {
            $this->USA_ResidenceType = $uSA_ResidenceType;
        }
        return $this;
    }
    /**
     * Get USA_Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUSA_Address()
    {
        return isset($this->USA_Address) ? $this->USA_Address : null;
    }
    /**
     * Set USA_Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uSA_Address
     * @return \StructType\AirTravelerTSAData
     */
    public function setUSA_Address($uSA_Address = null)
    {
        // validation for constraint: string
        if (!is_null($uSA_Address) && !is_string($uSA_Address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSA_Address, true), gettype($uSA_Address)), __LINE__);
        }
        if (is_null($uSA_Address) || (is_array($uSA_Address) && empty($uSA_Address))) {
            unset($this->USA_Address);
        } else {
            $this->USA_Address = $uSA_Address;
        }
        return $this;
    }
    /**
     * Get USA_ZipCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUSA_ZipCode()
    {
        return isset($this->USA_ZipCode) ? $this->USA_ZipCode : null;
    }
    /**
     * Set USA_ZipCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uSA_ZipCode
     * @return \StructType\AirTravelerTSAData
     */
    public function setUSA_ZipCode($uSA_ZipCode = null)
    {
        // validation for constraint: string
        if (!is_null($uSA_ZipCode) && !is_string($uSA_ZipCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uSA_ZipCode, true), gettype($uSA_ZipCode)), __LINE__);
        }
        if (is_null($uSA_ZipCode) || (is_array($uSA_ZipCode) && empty($uSA_ZipCode))) {
            unset($this->USA_ZipCode);
        } else {
            $this->USA_ZipCode = $uSA_ZipCode;
        }
        return $this;
    }
}
