<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricingGroupOption StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con la estructura necesaria para almacenar una combinación factible de vuelos, para completar un viaje. Basándonos en un grupo de precios (precio).
 * - nillable: true
 * - type: tns:AirPricingGroupOption
 * @subpackage Structs
 */
class AirPricingGroupOption extends AbstractStructBase
{
    /**
     * The PricingGroupOptionID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único de la combinación
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupOptionID;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Esquema de precio al que pertenece esta combinación
     * - minOccurs: 0
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ExternalReference
     * Meta information extracted from the WSDL
     * - documentation: Esta propiedad será usada para almacenar cualquier valor interesante que venga en la respuesta del proveedor.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Compañia con la que realizaremos la reserva y emitiremos los billetes
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The AirPricedItineraries
     * Meta information extracted from the WSDL
     * - documentation: Caracteristicas del grupo de precio de los itinerarios asociados a la combinación
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirPricedItinerary
     */
    public $AirPricedItineraries;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - documentation: Guardaremos el codigo de la tarifa actual (Galileo FIC: Este valor será usado para enviar posteriormente a la hora de reservar) Aqui pondremos las notas que sean necesarias por parte nuestra.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The AirlineLogoUrl
     * Meta information extracted from the WSDL
     * - documentation: En esta propiedad vendrá informado la url del logotipo que será servido por los servidores de servivuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AirlineLogoUrl;
    /**
     * The MandatoryTSAData
     * Meta information extracted from the WSDL
     * - documentation: Indica si es obligatorio enviar los datos de TSA a la hora de realizar la reserva.
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryTSAData;
    /**
     * The TransitUSA
     * Meta information extracted from the WSDL
     * - documentation: Indica si es la combiancion tiene algun itinerario con origen o destino USA
     * - minOccurs: 0
     * @var bool
     */
    public $TransitUSA;
    /**
     * The IsFareFamilies
     * Meta information extracted from the WSDL
     * - documentation: Indica si hay opción de FareFamilies para la combinacion
     * - minOccurs: 0
     * @var bool
     */
    public $IsFareFamilies;
    /**
     * Constructor method for AirPricingGroupOption
     * @uses AirPricingGroupOption::setPricingGroupOptionID()
     * @uses AirPricingGroupOption::setPricingGroupID()
     * @uses AirPricingGroupOption::setExternalReference()
     * @uses AirPricingGroupOption::setMarketingCarrierCode()
     * @uses AirPricingGroupOption::setAirPricedItineraries()
     * @uses AirPricingGroupOption::setNotes()
     * @uses AirPricingGroupOption::setAirlineLogoUrl()
     * @uses AirPricingGroupOption::setMandatoryTSAData()
     * @uses AirPricingGroupOption::setTransitUSA()
     * @uses AirPricingGroupOption::setIsFareFamilies()
     * @param int $pricingGroupOptionID
     * @param int $pricingGroupID
     * @param string $externalReference
     * @param string $marketingCarrierCode
     * @param \ArrayType\ArrayOfAirPricedItinerary $airPricedItineraries
     * @param string $notes
     * @param string $airlineLogoUrl
     * @param bool $mandatoryTSAData
     * @param bool $transitUSA
     * @param bool $isFareFamilies
     */
    public function __construct($pricingGroupOptionID = null, $pricingGroupID = null, $externalReference = null, $marketingCarrierCode = null, \ArrayType\ArrayOfAirPricedItinerary $airPricedItineraries = null, $notes = null, $airlineLogoUrl = null, $mandatoryTSAData = null, $transitUSA = null, $isFareFamilies = null)
    {
        $this
            ->setPricingGroupOptionID($pricingGroupOptionID)
            ->setPricingGroupID($pricingGroupID)
            ->setExternalReference($externalReference)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setAirPricedItineraries($airPricedItineraries)
            ->setNotes($notes)
            ->setAirlineLogoUrl($airlineLogoUrl)
            ->setMandatoryTSAData($mandatoryTSAData)
            ->setTransitUSA($transitUSA)
            ->setIsFareFamilies($isFareFamilies);
    }
    /**
     * Get PricingGroupOptionID value
     * @return int|null
     */
    public function getPricingGroupOptionID()
    {
        return $this->PricingGroupOptionID;
    }
    /**
     * Set PricingGroupOptionID value
     * @param int $pricingGroupOptionID
     * @return \StructType\AirPricingGroupOption
     */
    public function setPricingGroupOptionID($pricingGroupOptionID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupOptionID) && !(is_int($pricingGroupOptionID) || ctype_digit($pricingGroupOptionID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupOptionID, true), gettype($pricingGroupOptionID)), __LINE__);
        }
        $this->PricingGroupOptionID = $pricingGroupOptionID;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirPricingGroupOption
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \StructType\AirPricingGroupOption
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\AirPricingGroupOption
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get AirPricedItineraries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirPricedItinerary|null
     */
    public function getAirPricedItineraries()
    {
        return isset($this->AirPricedItineraries) ? $this->AirPricedItineraries : null;
    }
    /**
     * Set AirPricedItineraries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirPricedItinerary $airPricedItineraries
     * @return \StructType\AirPricingGroupOption
     */
    public function setAirPricedItineraries(\ArrayType\ArrayOfAirPricedItinerary $airPricedItineraries = null)
    {
        if (is_null($airPricedItineraries) || (is_array($airPricedItineraries) && empty($airPricedItineraries))) {
            unset($this->AirPricedItineraries);
        } else {
            $this->AirPricedItineraries = $airPricedItineraries;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \StructType\AirPricingGroupOption
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get AirlineLogoUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAirlineLogoUrl()
    {
        return isset($this->AirlineLogoUrl) ? $this->AirlineLogoUrl : null;
    }
    /**
     * Set AirlineLogoUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $airlineLogoUrl
     * @return \StructType\AirPricingGroupOption
     */
    public function setAirlineLogoUrl($airlineLogoUrl = null)
    {
        // validation for constraint: string
        if (!is_null($airlineLogoUrl) && !is_string($airlineLogoUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineLogoUrl, true), gettype($airlineLogoUrl)), __LINE__);
        }
        if (is_null($airlineLogoUrl) || (is_array($airlineLogoUrl) && empty($airlineLogoUrl))) {
            unset($this->AirlineLogoUrl);
        } else {
            $this->AirlineLogoUrl = $airlineLogoUrl;
        }
        return $this;
    }
    /**
     * Get MandatoryTSAData value
     * @return bool|null
     */
    public function getMandatoryTSAData()
    {
        return $this->MandatoryTSAData;
    }
    /**
     * Set MandatoryTSAData value
     * @param bool $mandatoryTSAData
     * @return \StructType\AirPricingGroupOption
     */
    public function setMandatoryTSAData($mandatoryTSAData = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryTSAData) && !is_bool($mandatoryTSAData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryTSAData, true), gettype($mandatoryTSAData)), __LINE__);
        }
        $this->MandatoryTSAData = $mandatoryTSAData;
        return $this;
    }
    /**
     * Get TransitUSA value
     * @return bool|null
     */
    public function getTransitUSA()
    {
        return $this->TransitUSA;
    }
    /**
     * Set TransitUSA value
     * @param bool $transitUSA
     * @return \StructType\AirPricingGroupOption
     */
    public function setTransitUSA($transitUSA = null)
    {
        // validation for constraint: boolean
        if (!is_null($transitUSA) && !is_bool($transitUSA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($transitUSA, true), gettype($transitUSA)), __LINE__);
        }
        $this->TransitUSA = $transitUSA;
        return $this;
    }
    /**
     * Get IsFareFamilies value
     * @return bool|null
     */
    public function getIsFareFamilies()
    {
        return $this->IsFareFamilies;
    }
    /**
     * Set IsFareFamilies value
     * @param bool $isFareFamilies
     * @return \StructType\AirPricingGroupOption
     */
    public function setIsFareFamilies($isFareFamilies = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFareFamilies) && !is_bool($isFareFamilies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFareFamilies, true), gettype($isFareFamilies)), __LINE__);
        }
        $this->IsFareFamilies = $isFareFamilies;
        return $this;
    }
}
