<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirPricedItineraryLeg StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que contiene los datos de un trayecto de un itinerario como la tarifa, clase, cabina, asientos disponibles, etc
 * - nillable: true
 * - type: tns:AirPricedItineraryLeg
 * @subpackage Structs
 */
class AirPricedItineraryLeg extends AbstractStructBase
{
    /**
     * The AirItineraryLegID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico del trayecto dentro de los itinerarios de la combinacion
     * - minOccurs: 0
     * @var int
     */
    public $AirItineraryLegID;
    /**
     * The FareCode
     * Meta information extracted from the WSDL
     * - documentation: Codigo que identifica el fare basis de esta combinación.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareCode;
    /**
     * The FareType
     * Meta information extracted from the WSDL
     * - documentation: Indica que tipos de tarifas se solicitarán, si son las tarifas publicas o las negociadas
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareType;
    /**
     * The CabinClass
     * Meta information extracted from the WSDL
     * - documentation: Clase de la reserva dentro de la cabina. Está definida por una letra y no hay una regla standar para todas las compañias, para conocer que letra corresponde a que cabina.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinClass;
    /**
     * The CabinType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de cambina, puede ser Economy, Business o Firts Class C: Business Class F: First Class M: Economy Standard W: Economy Premium
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CabinType;
    /**
     * The AvailableSeats
     * Meta information extracted from the WSDL
     * - documentation: Numero de asientos disponibles, el numero máximo es 9, que significa que hay 9 o más asientos disponibles
     * - minOccurs: 0
     * @var int
     */
    public $AvailableSeats;
    /**
     * The QuantityBaggageADT
     * Meta information extracted from the WSDL
     * - documentation: Cantidad de equipaje de tipo ADT
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuantityBaggageADT;
    /**
     * The QuantityWeightADT
     * Meta information extracted from the WSDL
     * - documentation: Peso del equipaje de tipo ADT
     * - minOccurs: 0
     * @var float
     */
    public $QuantityWeightADT;
    /**
     * The QuantityTypeADT
     * Meta information extracted from the WSDL
     * - documentation: Tipo del equipaje de tipo ADT
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuantityTypeADT;
    /**
     * The MeasureUnitADT
     * Meta information extracted from the WSDL
     * - documentation: Unidad de medida del equipaje de tipo ADT
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MeasureUnitADT;
    /**
     * Constructor method for AirPricedItineraryLeg
     * @uses AirPricedItineraryLeg::setAirItineraryLegID()
     * @uses AirPricedItineraryLeg::setFareCode()
     * @uses AirPricedItineraryLeg::setFareType()
     * @uses AirPricedItineraryLeg::setCabinClass()
     * @uses AirPricedItineraryLeg::setCabinType()
     * @uses AirPricedItineraryLeg::setAvailableSeats()
     * @uses AirPricedItineraryLeg::setQuantityBaggageADT()
     * @uses AirPricedItineraryLeg::setQuantityWeightADT()
     * @uses AirPricedItineraryLeg::setQuantityTypeADT()
     * @uses AirPricedItineraryLeg::setMeasureUnitADT()
     * @param int $airItineraryLegID
     * @param string $fareCode
     * @param string $fareType
     * @param string $cabinClass
     * @param string $cabinType
     * @param int $availableSeats
     * @param string $quantityBaggageADT
     * @param float $quantityWeightADT
     * @param string $quantityTypeADT
     * @param string $measureUnitADT
     */
    public function __construct($airItineraryLegID = null, $fareCode = null, $fareType = null, $cabinClass = null, $cabinType = null, $availableSeats = null, $quantityBaggageADT = null, $quantityWeightADT = null, $quantityTypeADT = null, $measureUnitADT = null)
    {
        $this
            ->setAirItineraryLegID($airItineraryLegID)
            ->setFareCode($fareCode)
            ->setFareType($fareType)
            ->setCabinClass($cabinClass)
            ->setCabinType($cabinType)
            ->setAvailableSeats($availableSeats)
            ->setQuantityBaggageADT($quantityBaggageADT)
            ->setQuantityWeightADT($quantityWeightADT)
            ->setQuantityTypeADT($quantityTypeADT)
            ->setMeasureUnitADT($measureUnitADT);
    }
    /**
     * Get AirItineraryLegID value
     * @return int|null
     */
    public function getAirItineraryLegID()
    {
        return $this->AirItineraryLegID;
    }
    /**
     * Set AirItineraryLegID value
     * @param int $airItineraryLegID
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setAirItineraryLegID($airItineraryLegID = null)
    {
        // validation for constraint: int
        if (!is_null($airItineraryLegID) && !(is_int($airItineraryLegID) || ctype_digit($airItineraryLegID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airItineraryLegID, true), gettype($airItineraryLegID)), __LINE__);
        }
        $this->AirItineraryLegID = $airItineraryLegID;
        return $this;
    }
    /**
     * Get FareCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareCode()
    {
        return isset($this->FareCode) ? $this->FareCode : null;
    }
    /**
     * Set FareCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareCode
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setFareCode($fareCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareCode) && !is_string($fareCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareCode, true), gettype($fareCode)), __LINE__);
        }
        if (is_null($fareCode) || (is_array($fareCode) && empty($fareCode))) {
            unset($this->FareCode);
        } else {
            $this->FareCode = $fareCode;
        }
        return $this;
    }
    /**
     * Get FareType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareType()
    {
        return isset($this->FareType) ? $this->FareType : null;
    }
    /**
     * Set FareType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareType
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setFareType($fareType = null)
    {
        // validation for constraint: string
        if (!is_null($fareType) && !is_string($fareType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareType, true), gettype($fareType)), __LINE__);
        }
        if (is_null($fareType) || (is_array($fareType) && empty($fareType))) {
            unset($this->FareType);
        } else {
            $this->FareType = $fareType;
        }
        return $this;
    }
    /**
     * Get CabinClass value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinClass()
    {
        return isset($this->CabinClass) ? $this->CabinClass : null;
    }
    /**
     * Set CabinClass value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinClass
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setCabinClass($cabinClass = null)
    {
        // validation for constraint: string
        if (!is_null($cabinClass) && !is_string($cabinClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinClass, true), gettype($cabinClass)), __LINE__);
        }
        if (is_null($cabinClass) || (is_array($cabinClass) && empty($cabinClass))) {
            unset($this->CabinClass);
        } else {
            $this->CabinClass = $cabinClass;
        }
        return $this;
    }
    /**
     * Get CabinType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCabinType()
    {
        return isset($this->CabinType) ? $this->CabinType : null;
    }
    /**
     * Set CabinType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cabinType
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setCabinType($cabinType = null)
    {
        // validation for constraint: string
        if (!is_null($cabinType) && !is_string($cabinType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cabinType, true), gettype($cabinType)), __LINE__);
        }
        if (is_null($cabinType) || (is_array($cabinType) && empty($cabinType))) {
            unset($this->CabinType);
        } else {
            $this->CabinType = $cabinType;
        }
        return $this;
    }
    /**
     * Get AvailableSeats value
     * @return int|null
     */
    public function getAvailableSeats()
    {
        return $this->AvailableSeats;
    }
    /**
     * Set AvailableSeats value
     * @param int $availableSeats
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setAvailableSeats($availableSeats = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeats) && !(is_int($availableSeats) || ctype_digit($availableSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeats, true), gettype($availableSeats)), __LINE__);
        }
        $this->AvailableSeats = $availableSeats;
        return $this;
    }
    /**
     * Get QuantityBaggageADT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuantityBaggageADT()
    {
        return isset($this->QuantityBaggageADT) ? $this->QuantityBaggageADT : null;
    }
    /**
     * Set QuantityBaggageADT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quantityBaggageADT
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setQuantityBaggageADT($quantityBaggageADT = null)
    {
        // validation for constraint: string
        if (!is_null($quantityBaggageADT) && !is_string($quantityBaggageADT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityBaggageADT, true), gettype($quantityBaggageADT)), __LINE__);
        }
        if (is_null($quantityBaggageADT) || (is_array($quantityBaggageADT) && empty($quantityBaggageADT))) {
            unset($this->QuantityBaggageADT);
        } else {
            $this->QuantityBaggageADT = $quantityBaggageADT;
        }
        return $this;
    }
    /**
     * Get QuantityWeightADT value
     * @return float|null
     */
    public function getQuantityWeightADT()
    {
        return $this->QuantityWeightADT;
    }
    /**
     * Set QuantityWeightADT value
     * @param float $quantityWeightADT
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setQuantityWeightADT($quantityWeightADT = null)
    {
        // validation for constraint: float
        if (!is_null($quantityWeightADT) && !(is_float($quantityWeightADT) || is_numeric($quantityWeightADT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityWeightADT, true), gettype($quantityWeightADT)), __LINE__);
        }
        $this->QuantityWeightADT = $quantityWeightADT;
        return $this;
    }
    /**
     * Get QuantityTypeADT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuantityTypeADT()
    {
        return isset($this->QuantityTypeADT) ? $this->QuantityTypeADT : null;
    }
    /**
     * Set QuantityTypeADT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quantityTypeADT
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setQuantityTypeADT($quantityTypeADT = null)
    {
        // validation for constraint: string
        if (!is_null($quantityTypeADT) && !is_string($quantityTypeADT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quantityTypeADT, true), gettype($quantityTypeADT)), __LINE__);
        }
        if (is_null($quantityTypeADT) || (is_array($quantityTypeADT) && empty($quantityTypeADT))) {
            unset($this->QuantityTypeADT);
        } else {
            $this->QuantityTypeADT = $quantityTypeADT;
        }
        return $this;
    }
    /**
     * Get MeasureUnitADT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeasureUnitADT()
    {
        return isset($this->MeasureUnitADT) ? $this->MeasureUnitADT : null;
    }
    /**
     * Set MeasureUnitADT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $measureUnitADT
     * @return \StructType\AirPricedItineraryLeg
     */
    public function setMeasureUnitADT($measureUnitADT = null)
    {
        // validation for constraint: string
        if (!is_null($measureUnitADT) && !is_string($measureUnitADT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measureUnitADT, true), gettype($measureUnitADT)), __LINE__);
        }
        if (is_null($measureUnitADT) || (is_array($measureUnitADT) && empty($measureUnitADT))) {
            unset($this->MeasureUnitADT);
        } else {
            $this->MeasureUnitADT = $measureUnitADT;
        }
        return $this;
    }
}
