<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryLeg StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa un vuelo
 * - nillable: true
 * - type: tns:AirItineraryLeg
 * @subpackage Structs
 */
class AirItineraryLeg extends AbstractStructBase
{
    /**
     * The TechnicalStops
     * Meta information extracted from the WSDL
     * - documentation: Paradas tecnicas del trayecto
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTechnicalStop
     */
    public $TechnicalStops;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de salida (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: Fecha y hora de llegada (formato dd/MM/aaaa HH:mm)
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código IATA del aeropuerto de llegada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The ArrivalAirportTerminal
     * Meta information extracted from the WSDL
     * - documentation: Terminal del aeropuerto de llegada
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportTerminal;
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Código IATA del aeropuerto de salida
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The DepartureAirportTerminal
     * Meta information extracted from the WSDL
     * - documentation: Terminal del aeropuerto de salida
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportTerminal;
    /**
     * The AirItineraryLegID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del trayecto
     * - minOccurs: 0
     * @var int
     */
    public $AirItineraryLegID;
    /**
     * The ItineraryID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del itinerario
     * - minOccurs: 0
     * @var int
     */
    public $ItineraryID;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: Número de vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightNumber;
    /**
     * The OperatingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la compañia que opera el vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The MarketingCarrierCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la compañia que vende el vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The AircraftType
     * Meta information extracted from the WSDL
     * - documentation: Tipo de equipo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftType;
    /**
     * Constructor method for AirItineraryLeg
     * @uses AirItineraryLeg::setTechnicalStops()
     * @uses AirItineraryLeg::setDepartureDateTime()
     * @uses AirItineraryLeg::setArrivalDateTime()
     * @uses AirItineraryLeg::setArrivalAirportLocationCode()
     * @uses AirItineraryLeg::setArrivalAirportTerminal()
     * @uses AirItineraryLeg::setDepartureAirportLocationCode()
     * @uses AirItineraryLeg::setDepartureAirportTerminal()
     * @uses AirItineraryLeg::setAirItineraryLegID()
     * @uses AirItineraryLeg::setItineraryID()
     * @uses AirItineraryLeg::setFlightNumber()
     * @uses AirItineraryLeg::setOperatingCarrierCode()
     * @uses AirItineraryLeg::setMarketingCarrierCode()
     * @uses AirItineraryLeg::setAircraftType()
     * @param \ArrayType\ArrayOfAirTechnicalStop $technicalStops
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param string $arrivalAirportLocationCode
     * @param string $arrivalAirportTerminal
     * @param string $departureAirportLocationCode
     * @param string $departureAirportTerminal
     * @param int $airItineraryLegID
     * @param int $itineraryID
     * @param string $flightNumber
     * @param string $operatingCarrierCode
     * @param string $marketingCarrierCode
     * @param string $aircraftType
     */
    public function __construct(\ArrayType\ArrayOfAirTechnicalStop $technicalStops = null, $departureDateTime = null, $arrivalDateTime = null, $arrivalAirportLocationCode = null, $arrivalAirportTerminal = null, $departureAirportLocationCode = null, $departureAirportTerminal = null, $airItineraryLegID = null, $itineraryID = null, $flightNumber = null, $operatingCarrierCode = null, $marketingCarrierCode = null, $aircraftType = null)
    {
        $this
            ->setTechnicalStops($technicalStops)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setArrivalAirportTerminal($arrivalAirportTerminal)
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setDepartureAirportTerminal($departureAirportTerminal)
            ->setAirItineraryLegID($airItineraryLegID)
            ->setItineraryID($itineraryID)
            ->setFlightNumber($flightNumber)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setAircraftType($aircraftType);
    }
    /**
     * Get TechnicalStops value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTechnicalStop|null
     */
    public function getTechnicalStops()
    {
        return isset($this->TechnicalStops) ? $this->TechnicalStops : null;
    }
    /**
     * Set TechnicalStops value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTechnicalStop $technicalStops
     * @return \StructType\AirItineraryLeg
     */
    public function setTechnicalStops(\ArrayType\ArrayOfAirTechnicalStop $technicalStops = null)
    {
        if (is_null($technicalStops) || (is_array($technicalStops) && empty($technicalStops))) {
            unset($this->TechnicalStops);
        } else {
            $this->TechnicalStops = $technicalStops;
        }
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return isset($this->DepartureDateTime) ? $this->DepartureDateTime : null;
    }
    /**
     * Set DepartureDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDateTime
     * @return \StructType\AirItineraryLeg
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        if (is_null($departureDateTime) || (is_array($departureDateTime) && empty($departureDateTime))) {
            unset($this->DepartureDateTime);
        } else {
            $this->DepartureDateTime = $departureDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return isset($this->ArrivalDateTime) ? $this->ArrivalDateTime : null;
    }
    /**
     * Set ArrivalDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalDateTime
     * @return \StructType\AirItineraryLeg
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        if (is_null($arrivalDateTime) || (is_array($arrivalDateTime) && empty($arrivalDateTime))) {
            unset($this->ArrivalDateTime);
        } else {
            $this->ArrivalDateTime = $arrivalDateTime;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirItineraryLeg
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportTerminal()
    {
        return isset($this->ArrivalAirportTerminal) ? $this->ArrivalAirportTerminal : null;
    }
    /**
     * Set ArrivalAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportTerminal
     * @return \StructType\AirItineraryLeg
     */
    public function setArrivalAirportTerminal($arrivalAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportTerminal) && !is_string($arrivalAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportTerminal, true), gettype($arrivalAirportTerminal)), __LINE__);
        }
        if (is_null($arrivalAirportTerminal) || (is_array($arrivalAirportTerminal) && empty($arrivalAirportTerminal))) {
            unset($this->ArrivalAirportTerminal);
        } else {
            $this->ArrivalAirportTerminal = $arrivalAirportTerminal;
        }
        return $this;
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirItineraryLeg
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get DepartureAirportTerminal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportTerminal()
    {
        return isset($this->DepartureAirportTerminal) ? $this->DepartureAirportTerminal : null;
    }
    /**
     * Set DepartureAirportTerminal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportTerminal
     * @return \StructType\AirItineraryLeg
     */
    public function setDepartureAirportTerminal($departureAirportTerminal = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportTerminal) && !is_string($departureAirportTerminal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportTerminal, true), gettype($departureAirportTerminal)), __LINE__);
        }
        if (is_null($departureAirportTerminal) || (is_array($departureAirportTerminal) && empty($departureAirportTerminal))) {
            unset($this->DepartureAirportTerminal);
        } else {
            $this->DepartureAirportTerminal = $departureAirportTerminal;
        }
        return $this;
    }
    /**
     * Get AirItineraryLegID value
     * @return int|null
     */
    public function getAirItineraryLegID()
    {
        return $this->AirItineraryLegID;
    }
    /**
     * Set AirItineraryLegID value
     * @param int $airItineraryLegID
     * @return \StructType\AirItineraryLeg
     */
    public function setAirItineraryLegID($airItineraryLegID = null)
    {
        // validation for constraint: int
        if (!is_null($airItineraryLegID) && !(is_int($airItineraryLegID) || ctype_digit($airItineraryLegID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($airItineraryLegID, true), gettype($airItineraryLegID)), __LINE__);
        }
        $this->AirItineraryLegID = $airItineraryLegID;
        return $this;
    }
    /**
     * Get ItineraryID value
     * @return int|null
     */
    public function getItineraryID()
    {
        return $this->ItineraryID;
    }
    /**
     * Set ItineraryID value
     * @param int $itineraryID
     * @return \StructType\AirItineraryLeg
     */
    public function setItineraryID($itineraryID = null)
    {
        // validation for constraint: int
        if (!is_null($itineraryID) && !(is_int($itineraryID) || ctype_digit($itineraryID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itineraryID, true), gettype($itineraryID)), __LINE__);
        }
        $this->ItineraryID = $itineraryID;
        return $this;
    }
    /**
     * Get FlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightNumber()
    {
        return isset($this->FlightNumber) ? $this->FlightNumber : null;
    }
    /**
     * Set FlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightNumber
     * @return \StructType\AirItineraryLeg
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($flightNumber) && !is_string($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flightNumber, true), gettype($flightNumber)), __LINE__);
        }
        if (is_null($flightNumber) || (is_array($flightNumber) && empty($flightNumber))) {
            unset($this->FlightNumber);
        } else {
            $this->FlightNumber = $flightNumber;
        }
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return isset($this->OperatingCarrierCode) ? $this->OperatingCarrierCode : null;
    }
    /**
     * Set OperatingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrierCode
     * @return \StructType\AirItineraryLeg
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operatingCarrierCode, true), gettype($operatingCarrierCode)), __LINE__);
        }
        if (is_null($operatingCarrierCode) || (is_array($operatingCarrierCode) && empty($operatingCarrierCode))) {
            unset($this->OperatingCarrierCode);
        } else {
            $this->OperatingCarrierCode = $operatingCarrierCode;
        }
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\AirItineraryLeg
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marketingCarrierCode, true), gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get AircraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftType()
    {
        return isset($this->AircraftType) ? $this->AircraftType : null;
    }
    /**
     * Set AircraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftType
     * @return \StructType\AirItineraryLeg
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftType, true), gettype($aircraftType)), __LINE__);
        }
        if (is_null($aircraftType) || (is_array($aircraftType) && empty($aircraftType))) {
            unset($this->AircraftType);
        } else {
            $this->AircraftType = $aircraftType;
        }
        return $this;
    }
}
