<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFareFamiliesPrice StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que contiene los precios para FareFamilies
 * - nillable: true
 * - type: tns:AirFareFamiliesPrice
 * @subpackage Structs
 */
class AirFareFamiliesPrice extends AbstractStructBase
{
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - documentation: Moneda en que se va a aplicar la cotización
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Currency;
    /**
     * The TotalAgencyAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total neto agencia para la reserva con FF. Propiedad calculada en base a la suma de precios por pasajero.
     * - minOccurs: 0
     * @var float
     */
    public $TotalAgencyAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - documentation: Precio total reserva con FF incluido fees. Propiedad calculada en base a la suma de precios por pasajero.
     * - minOccurs: 0
     * @var float
     */
    public $TotalAmount;
    /**
     * The AmountDifferenceAvail
     * Meta information extracted from the WSDL
     * - documentation: Diferencia entre Importe FF e Importe Total Disponibilidad
     * - minOccurs: 0
     * @var float
     */
    public $AmountDifferenceAvail;
    /**
     * Constructor method for AirFareFamiliesPrice
     * @uses AirFareFamiliesPrice::setCurrency()
     * @uses AirFareFamiliesPrice::setTotalAgencyAmount()
     * @uses AirFareFamiliesPrice::setTotalAmount()
     * @uses AirFareFamiliesPrice::setAmountDifferenceAvail()
     * @param string $currency
     * @param float $totalAgencyAmount
     * @param float $totalAmount
     * @param float $amountDifferenceAvail
     */
    public function __construct($currency = null, $totalAgencyAmount = null, $totalAmount = null, $amountDifferenceAvail = null)
    {
        $this
            ->setCurrency($currency)
            ->setTotalAgencyAmount($totalAgencyAmount)
            ->setTotalAmount($totalAmount)
            ->setAmountDifferenceAvail($amountDifferenceAvail);
    }
    /**
     * Get Currency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrency()
    {
        return isset($this->Currency) ? $this->Currency : null;
    }
    /**
     * Set Currency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currency
     * @return \StructType\AirFareFamiliesPrice
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        if (is_null($currency) || (is_array($currency) && empty($currency))) {
            unset($this->Currency);
        } else {
            $this->Currency = $currency;
        }
        return $this;
    }
    /**
     * Get TotalAgencyAmount value
     * @return float|null
     */
    public function getTotalAgencyAmount()
    {
        return $this->TotalAgencyAmount;
    }
    /**
     * Set TotalAgencyAmount value
     * @param float $totalAgencyAmount
     * @return \StructType\AirFareFamiliesPrice
     */
    public function setTotalAgencyAmount($totalAgencyAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAgencyAmount) && !(is_float($totalAgencyAmount) || is_numeric($totalAgencyAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAgencyAmount, true), gettype($totalAgencyAmount)), __LINE__);
        }
        $this->TotalAgencyAmount = $totalAgencyAmount;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return float|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param float $totalAmount
     * @return \StructType\AirFareFamiliesPrice
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get AmountDifferenceAvail value
     * @return float|null
     */
    public function getAmountDifferenceAvail()
    {
        return $this->AmountDifferenceAvail;
    }
    /**
     * Set AmountDifferenceAvail value
     * @param float $amountDifferenceAvail
     * @return \StructType\AirFareFamiliesPrice
     */
    public function setAmountDifferenceAvail($amountDifferenceAvail = null)
    {
        // validation for constraint: float
        if (!is_null($amountDifferenceAvail) && !(is_float($amountDifferenceAvail) || is_numeric($amountDifferenceAvail))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amountDifferenceAvail, true), gettype($amountDifferenceAvail)), __LINE__);
        }
        $this->AmountDifferenceAvail = $amountDifferenceAvail;
        return $this;
    }
}
