<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirFareFamiliesFlightSegmentLeg StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto auxiliar para contener la información asociada a los trayectos de vuelo
 * - nillable: true
 * - type: tns:AirFareFamiliesFlightSegmentLeg
 * @subpackage Structs
 */
class AirFareFamiliesFlightSegmentLeg extends AbstractStructBase
{
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Iata Origen del Trayecto de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: Iata Destino del Trayecto de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripcion de la FareFamilies de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Nombre de la FareFamilies de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The FareBasis
     * Meta information extracted from the WSDL
     * - documentation: Codigo de Tarifa de la FareFamilies de Vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FareBasis;
    /**
     * The BaggageQuantity
     * Meta information extracted from the WSDL
     * - documentation: Cantidad de maletas de la FareFamilies de Vuelo
     * - minOccurs: 0
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - documentation: Estructura dónde se almacenará la información de los servicios incluidos asociados a la opción de FareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Services;
    /**
     * Constructor method for AirFareFamiliesFlightSegmentLeg
     * @uses AirFareFamiliesFlightSegmentLeg::setDepartureAirportLocationCode()
     * @uses AirFareFamiliesFlightSegmentLeg::setArrivalAirportLocationCode()
     * @uses AirFareFamiliesFlightSegmentLeg::setDescription()
     * @uses AirFareFamiliesFlightSegmentLeg::setName()
     * @uses AirFareFamiliesFlightSegmentLeg::setFareBasis()
     * @uses AirFareFamiliesFlightSegmentLeg::setBaggageQuantity()
     * @uses AirFareFamiliesFlightSegmentLeg::setServices()
     * @param string $departureAirportLocationCode
     * @param string $arrivalAirportLocationCode
     * @param string $description
     * @param string $name
     * @param string $fareBasis
     * @param int $baggageQuantity
     * @param \ArrayType\ArrayOfstring $services
     */
    public function __construct($departureAirportLocationCode = null, $arrivalAirportLocationCode = null, $description = null, $name = null, $fareBasis = null, $baggageQuantity = null, \ArrayType\ArrayOfstring $services = null)
    {
        $this
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDescription($description)
            ->setName($name)
            ->setFareBasis($fareBasis)
            ->setBaggageQuantity($baggageQuantity)
            ->setServices($services);
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get FareBasis value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFareBasis()
    {
        return isset($this->FareBasis) ? $this->FareBasis : null;
    }
    /**
     * Set FareBasis value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fareBasis
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setFareBasis($fareBasis = null)
    {
        // validation for constraint: string
        if (!is_null($fareBasis) && !is_string($fareBasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareBasis, true), gettype($fareBasis)), __LINE__);
        }
        if (is_null($fareBasis) || (is_array($fareBasis) && empty($fareBasis))) {
            unset($this->FareBasis);
        } else {
            $this->FareBasis = $fareBasis;
        }
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !(is_int($baggageQuantity) || ctype_digit($baggageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baggageQuantity, true), gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get Services value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getServices()
    {
        return isset($this->Services) ? $this->Services : null;
    }
    /**
     * Set Services value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $services
     * @return \StructType\AirFareFamiliesFlightSegmentLeg
     */
    public function setServices(\ArrayType\ArrayOfstring $services = null)
    {
        if (is_null($services) || (is_array($services) && empty($services))) {
            unset($this->Services);
        } else {
            $this->Services = $services;
        }
        return $this;
    }
}
