<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingUpdateTravelerTSADataRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto Response con los datos de salida del metodo web AirBookingUpdateTravelerTSAData
 * - nillable: true
 * - type: tns:AirBookingUpdateTravelerTSADataRS
 * @subpackage Structs
 */
class AirBookingUpdateTravelerTSADataRS extends AbstractStructBase
{
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador único de la peticion que se realiza al webservice del motor
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al modificar los datos TSA de un pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirBookingUpdateTravelerTSADataRS
     * @uses AirBookingUpdateTravelerTSADataRS::setRequestID()
     * @uses AirBookingUpdateTravelerTSADataRS::setError()
     * @param int $requestID
     * @param \StructType\ResponseError $error
     */
    public function __construct($requestID = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRequestID($requestID)
            ->setError($error);
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirBookingUpdateTravelerTSADataRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingUpdateTravelerTSADataRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
