<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingUpdateTravelerTSADataRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto de Request para modificar los datos TSA de un pasajero de una reserva para pasajeros que viajan a EEUU
 * - nillable: true
 * - type: tns:AirBookingUpdateTravelerTSADataRQ
 * @subpackage Structs
 */
class AirBookingUpdateTravelerTSADataRQ extends AbstractStructBase
{
    /**
     * The BookingID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico de la reserva en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $BookingID;
    /**
     * The TravelerID
     * Meta information extracted from the WSDL
     * - documentation: Identificador unico del pasajero en el sistema Aramix
     * - minOccurs: 0
     * @var int
     */
    public $TravelerID;
    /**
     * The TravelerTSAData
     * Meta information extracted from the WSDL
     * - documentation: Datos TSA del pasajero
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirTravelerTSAData
     */
    public $TravelerTSAData;
    /**
     * Constructor method for AirBookingUpdateTravelerTSADataRQ
     * @uses AirBookingUpdateTravelerTSADataRQ::setBookingID()
     * @uses AirBookingUpdateTravelerTSADataRQ::setTravelerID()
     * @uses AirBookingUpdateTravelerTSADataRQ::setTravelerTSAData()
     * @param int $bookingID
     * @param int $travelerID
     * @param \StructType\AirTravelerTSAData $travelerTSAData
     */
    public function __construct($bookingID = null, $travelerID = null, \StructType\AirTravelerTSAData $travelerTSAData = null)
    {
        $this
            ->setBookingID($bookingID)
            ->setTravelerID($travelerID)
            ->setTravelerTSAData($travelerTSAData);
    }
    /**
     * Get BookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->BookingID;
    }
    /**
     * Set BookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingUpdateTravelerTSADataRQ
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->BookingID = $bookingID;
        return $this;
    }
    /**
     * Get TravelerID value
     * @return int|null
     */
    public function getTravelerID()
    {
        return $this->TravelerID;
    }
    /**
     * Set TravelerID value
     * @param int $travelerID
     * @return \StructType\AirBookingUpdateTravelerTSADataRQ
     */
    public function setTravelerID($travelerID = null)
    {
        // validation for constraint: int
        if (!is_null($travelerID) && !(is_int($travelerID) || ctype_digit($travelerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerID, true), gettype($travelerID)), __LINE__);
        }
        $this->TravelerID = $travelerID;
        return $this;
    }
    /**
     * Get TravelerTSAData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirTravelerTSAData|null
     */
    public function getTravelerTSAData()
    {
        return isset($this->TravelerTSAData) ? $this->TravelerTSAData : null;
    }
    /**
     * Set TravelerTSAData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirTravelerTSAData $travelerTSAData
     * @return \StructType\AirBookingUpdateTravelerTSADataRQ
     */
    public function setTravelerTSAData(\StructType\AirTravelerTSAData $travelerTSAData = null)
    {
        if (is_null($travelerTSAData) || (is_array($travelerTSAData) && empty($travelerTSAData))) {
            unset($this->TravelerTSAData);
        } else {
            $this->TravelerTSAData = $travelerTSAData;
        }
        return $this;
    }
}
