<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingSearchRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con el response del buscador de reservas
 * - nillable: true
 * - type: tns:AirBookingSearchRS
 * @subpackage Structs
 */
class AirBookingSearchRS extends AbstractStructBase
{
    /**
     * The RecordCount
     * Meta information extracted from the WSDL
     * - documentation: Numero total de registros a devolver
     * - minOccurs: 0
     * @var int
     */
    public $RecordCount;
    /**
     * The AirBookings
     * Meta information extracted from the WSDL
     * - documentation: Lista de reservas devueltas por la búsqueda
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirBookingSearchItem
     */
    public $AirBookings;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al recuperar las reservas
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * Constructor method for AirBookingSearchRS
     * @uses AirBookingSearchRS::setRecordCount()
     * @uses AirBookingSearchRS::setAirBookings()
     * @uses AirBookingSearchRS::setError()
     * @param int $recordCount
     * @param \ArrayType\ArrayOfAirBookingSearchItem $airBookings
     * @param \StructType\ResponseError $error
     */
    public function __construct($recordCount = null, \ArrayType\ArrayOfAirBookingSearchItem $airBookings = null, \StructType\ResponseError $error = null)
    {
        $this
            ->setRecordCount($recordCount)
            ->setAirBookings($airBookings)
            ->setError($error);
    }
    /**
     * Get RecordCount value
     * @return int|null
     */
    public function getRecordCount()
    {
        return $this->RecordCount;
    }
    /**
     * Set RecordCount value
     * @param int $recordCount
     * @return \StructType\AirBookingSearchRS
     */
    public function setRecordCount($recordCount = null)
    {
        // validation for constraint: int
        if (!is_null($recordCount) && !(is_int($recordCount) || ctype_digit($recordCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordCount, true), gettype($recordCount)), __LINE__);
        }
        $this->RecordCount = $recordCount;
        return $this;
    }
    /**
     * Get AirBookings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirBookingSearchItem|null
     */
    public function getAirBookings()
    {
        return isset($this->AirBookings) ? $this->AirBookings : null;
    }
    /**
     * Set AirBookings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirBookingSearchItem $airBookings
     * @return \StructType\AirBookingSearchRS
     */
    public function setAirBookings(\ArrayType\ArrayOfAirBookingSearchItem $airBookings = null)
    {
        if (is_null($airBookings) || (is_array($airBookings) && empty($airBookings))) {
            unset($this->AirBookings);
        } else {
            $this->AirBookings = $airBookings;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingSearchRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
}
