<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una reserva aérea
 * - nillable: true
 * - type: tns:AirBookingRS
 * @subpackage Structs
 */
class AirBookingRS extends AbstractStructBase
{
    /**
     * The AirBooking
     * Meta information extracted from the WSDL
     * - documentation: Datos de la reserva (null en caso de error)
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBooking
     */
    public $AirBooking;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - documentation: Informa si se produce un error al tratar de crear, editar o cancelar la reserva
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ResponseError
     */
    public $Error;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificador de la petición asociada al metodo invocado para devolver el objeto
     * - minOccurs: 0
     * @var int
     */
    public $RequestID;
    /**
     * Constructor method for AirBookingRS
     * @uses AirBookingRS::setAirBooking()
     * @uses AirBookingRS::setError()
     * @uses AirBookingRS::setRequestID()
     * @param \StructType\AirBooking $airBooking
     * @param \StructType\ResponseError $error
     * @param int $requestID
     */
    public function __construct(\StructType\AirBooking $airBooking = null, \StructType\ResponseError $error = null, $requestID = null)
    {
        $this
            ->setAirBooking($airBooking)
            ->setError($error)
            ->setRequestID($requestID);
    }
    /**
     * Get AirBooking value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBooking|null
     */
    public function getAirBooking()
    {
        return isset($this->AirBooking) ? $this->AirBooking : null;
    }
    /**
     * Set AirBooking value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBooking $airBooking
     * @return \StructType\AirBookingRS
     */
    public function setAirBooking(\StructType\AirBooking $airBooking = null)
    {
        if (is_null($airBooking) || (is_array($airBooking) && empty($airBooking))) {
            unset($this->AirBooking);
        } else {
            $this->AirBooking = $airBooking;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ResponseError|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ResponseError $error
     * @return \StructType\AirBookingRS
     */
    public function setError(\StructType\ResponseError $error = null)
    {
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get RequestID value
     * @return int|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param int $requestID
     * @return \StructType\AirBookingRS
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: int
        if (!is_null($requestID) && !(is_int($requestID) || ctype_digit($requestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
}
