<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingPaxFare StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una de las lineas de tarifas disponibles para un pasajero
 * - nillable: true
 * - type: tns:AirBookingPaxFare
 * @subpackage Structs
 */
class AirBookingPaxFare extends AbstractStructBase
{
    /**
     * The TicketAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del billete para este pasajero en esta reserva
     * - minOccurs: 0
     * @var float
     */
    public $TicketAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de las tasas para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The AgencyFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee de agencia para la reserva para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $AgencyFeeAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee Aramix para la reserva para este pasajero
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The OBFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe del fee que cobra la aerolinea por pago con tarjeta de crédito
     * - minOccurs: 0
     * @var float
     */
    public $OBFeeAmount;
    /**
     * The LstAirTravelerFlightSegmentLeg
     * Meta information extracted from the WSDL
     * - documentation: Lista de asociacion de cada pasajero con cada vuelo, en al que se puede encontrar el equipaje permitido para cada pasajero y vuelo
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTravelerFlightSegmentLeg
     */
    public $LstAirTravelerFlightSegmentLeg;
    /**
     * Constructor method for AirBookingPaxFare
     * @uses AirBookingPaxFare::setTicketAmount()
     * @uses AirBookingPaxFare::setTaxAmount()
     * @uses AirBookingPaxFare::setAgencyFeeAmount()
     * @uses AirBookingPaxFare::setAramixFeeAmount()
     * @uses AirBookingPaxFare::setOBFeeAmount()
     * @uses AirBookingPaxFare::setLstAirTravelerFlightSegmentLeg()
     * @param float $ticketAmount
     * @param float $taxAmount
     * @param float $agencyFeeAmount
     * @param float $aramixFeeAmount
     * @param float $oBFeeAmount
     * @param \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg
     */
    public function __construct($ticketAmount = null, $taxAmount = null, $agencyFeeAmount = null, $aramixFeeAmount = null, $oBFeeAmount = null, \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg = null)
    {
        $this
            ->setTicketAmount($ticketAmount)
            ->setTaxAmount($taxAmount)
            ->setAgencyFeeAmount($agencyFeeAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setOBFeeAmount($oBFeeAmount)
            ->setLstAirTravelerFlightSegmentLeg($lstAirTravelerFlightSegmentLeg);
    }
    /**
     * Get TicketAmount value
     * @return float|null
     */
    public function getTicketAmount()
    {
        return $this->TicketAmount;
    }
    /**
     * Set TicketAmount value
     * @param float $ticketAmount
     * @return \StructType\AirBookingPaxFare
     */
    public function setTicketAmount($ticketAmount = null)
    {
        // validation for constraint: float
        if (!is_null($ticketAmount) && !(is_float($ticketAmount) || is_numeric($ticketAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($ticketAmount, true), gettype($ticketAmount)), __LINE__);
        }
        $this->TicketAmount = $ticketAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\AirBookingPaxFare
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get AgencyFeeAmount value
     * @return float|null
     */
    public function getAgencyFeeAmount()
    {
        return $this->AgencyFeeAmount;
    }
    /**
     * Set AgencyFeeAmount value
     * @param float $agencyFeeAmount
     * @return \StructType\AirBookingPaxFare
     */
    public function setAgencyFeeAmount($agencyFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agencyFeeAmount) && !(is_float($agencyFeeAmount) || is_numeric($agencyFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyFeeAmount, true), gettype($agencyFeeAmount)), __LINE__);
        }
        $this->AgencyFeeAmount = $agencyFeeAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirBookingPaxFare
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get OBFeeAmount value
     * @return float|null
     */
    public function getOBFeeAmount()
    {
        return $this->OBFeeAmount;
    }
    /**
     * Set OBFeeAmount value
     * @param float $oBFeeAmount
     * @return \StructType\AirBookingPaxFare
     */
    public function setOBFeeAmount($oBFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($oBFeeAmount) && !(is_float($oBFeeAmount) || is_numeric($oBFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($oBFeeAmount, true), gettype($oBFeeAmount)), __LINE__);
        }
        $this->OBFeeAmount = $oBFeeAmount;
        return $this;
    }
    /**
     * Get LstAirTravelerFlightSegmentLeg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTravelerFlightSegmentLeg|null
     */
    public function getLstAirTravelerFlightSegmentLeg()
    {
        return isset($this->LstAirTravelerFlightSegmentLeg) ? $this->LstAirTravelerFlightSegmentLeg : null;
    }
    /**
     * Set LstAirTravelerFlightSegmentLeg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg
     * @return \StructType\AirBookingPaxFare
     */
    public function setLstAirTravelerFlightSegmentLeg(\ArrayType\ArrayOfAirTravelerFlightSegmentLeg $lstAirTravelerFlightSegmentLeg = null)
    {
        if (is_null($lstAirTravelerFlightSegmentLeg) || (is_array($lstAirTravelerFlightSegmentLeg) && empty($lstAirTravelerFlightSegmentLeg))) {
            unset($this->LstAirTravelerFlightSegmentLeg);
        } else {
            $this->LstAirTravelerFlightSegmentLeg = $lstAirTravelerFlightSegmentLeg;
        }
        return $this;
    }
}
