<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingNote StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa las notas de tarifa de una reserva
 * - nillable: true
 * - type: tns:AirBookingNote
 * @subpackage Structs
 */
class AirBookingNote extends AbstractStructBase
{
    /**
     * The NoteCode
     * Meta information extracted from the WSDL
     * - documentation: Código de la nota
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NoteCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripción de la nota
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AirBookingNote
     * @uses AirBookingNote::setNoteCode()
     * @uses AirBookingNote::setDescription()
     * @param string $noteCode
     * @param string $description
     */
    public function __construct($noteCode = null, $description = null)
    {
        $this
            ->setNoteCode($noteCode)
            ->setDescription($description);
    }
    /**
     * Get NoteCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNoteCode()
    {
        return isset($this->NoteCode) ? $this->NoteCode : null;
    }
    /**
     * Set NoteCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $noteCode
     * @return \StructType\AirBookingNote
     */
    public function setNoteCode($noteCode = null)
    {
        // validation for constraint: string
        if (!is_null($noteCode) && !is_string($noteCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($noteCode, true), gettype($noteCode)), __LINE__);
        }
        if (is_null($noteCode) || (is_array($noteCode) && empty($noteCode))) {
            unset($this->NoteCode);
        } else {
            $this->NoteCode = $noteCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirBookingNote
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
