<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingMarkToTicketing StructType
 * @subpackage Structs
 */
class AirBookingMarkToTicketing extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The airBookingMarkToTicketingRQ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirBookingMarkToTicketingRQ
     */
    public $airBookingMarkToTicketingRQ;
    /**
     * Constructor method for AirBookingMarkToTicketing
     * @uses AirBookingMarkToTicketing::setCredentials()
     * @uses AirBookingMarkToTicketing::setAirBookingMarkToTicketingRQ()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param \StructType\AirBookingMarkToTicketingRQ $airBookingMarkToTicketingRQ
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, \StructType\AirBookingMarkToTicketingRQ $airBookingMarkToTicketingRQ = null)
    {
        $this
            ->setCredentials($credentials)
            ->setAirBookingMarkToTicketingRQ($airBookingMarkToTicketingRQ);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingMarkToTicketing
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get airBookingMarkToTicketingRQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirBookingMarkToTicketingRQ|null
     */
    public function getAirBookingMarkToTicketingRQ()
    {
        return isset($this->airBookingMarkToTicketingRQ) ? $this->airBookingMarkToTicketingRQ : null;
    }
    /**
     * Set airBookingMarkToTicketingRQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirBookingMarkToTicketingRQ $airBookingMarkToTicketingRQ
     * @return \StructType\AirBookingMarkToTicketing
     */
    public function setAirBookingMarkToTicketingRQ(\StructType\AirBookingMarkToTicketingRQ $airBookingMarkToTicketingRQ = null)
    {
        if (is_null($airBookingMarkToTicketingRQ) || (is_array($airBookingMarkToTicketingRQ) && empty($airBookingMarkToTicketingRQ))) {
            unset($this->airBookingMarkToTicketingRQ);
        } else {
            $this->airBookingMarkToTicketingRQ = $airBookingMarkToTicketingRQ;
        }
        return $this;
    }
}
