<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingGetPaxFares StructType
 * @subpackage Structs
 */
class AirBookingGetPaxFares extends AbstractStructBase
{
    /**
     * The credentials
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AuthenticationCredentials
     */
    public $credentials;
    /**
     * The bookingID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $bookingID;
    /**
     * The travelerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $travelerID;
    /**
     * Constructor method for AirBookingGetPaxFares
     * @uses AirBookingGetPaxFares::setCredentials()
     * @uses AirBookingGetPaxFares::setBookingID()
     * @uses AirBookingGetPaxFares::setTravelerID()
     * @param \StructType\AuthenticationCredentials $credentials
     * @param int $bookingID
     * @param int $travelerID
     */
    public function __construct(\StructType\AuthenticationCredentials $credentials = null, $bookingID = null, $travelerID = null)
    {
        $this
            ->setCredentials($credentials)
            ->setBookingID($bookingID)
            ->setTravelerID($travelerID);
    }
    /**
     * Get credentials value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AuthenticationCredentials|null
     */
    public function getCredentials()
    {
        return isset($this->credentials) ? $this->credentials : null;
    }
    /**
     * Set credentials value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AuthenticationCredentials $credentials
     * @return \StructType\AirBookingGetPaxFares
     */
    public function setCredentials(\StructType\AuthenticationCredentials $credentials = null)
    {
        if (is_null($credentials) || (is_array($credentials) && empty($credentials))) {
            unset($this->credentials);
        } else {
            $this->credentials = $credentials;
        }
        return $this;
    }
    /**
     * Get bookingID value
     * @return int|null
     */
    public function getBookingID()
    {
        return $this->bookingID;
    }
    /**
     * Set bookingID value
     * @param int $bookingID
     * @return \StructType\AirBookingGetPaxFares
     */
    public function setBookingID($bookingID = null)
    {
        // validation for constraint: int
        if (!is_null($bookingID) && !(is_int($bookingID) || ctype_digit($bookingID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bookingID, true), gettype($bookingID)), __LINE__);
        }
        $this->bookingID = $bookingID;
        return $this;
    }
    /**
     * Get travelerID value
     * @return int|null
     */
    public function getTravelerID()
    {
        return $this->travelerID;
    }
    /**
     * Set travelerID value
     * @param int $travelerID
     * @return \StructType\AirBookingGetPaxFares
     */
    public function setTravelerID($travelerID = null)
    {
        // validation for constraint: int
        if (!is_null($travelerID) && !(is_int($travelerID) || ctype_digit($travelerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($travelerID, true), gettype($travelerID)), __LINE__);
        }
        $this->travelerID = $travelerID;
        return $this;
    }
}
