<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingFareFamilies StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada, para recuperar las FareFamilies asociadas a una combinación de vuelos
 * - nillable: true
 * - type: tns:AirBookingFareFamilies
 * @subpackage Structs
 */
class AirBookingFareFamilies extends AbstractStructBase
{
    /**
     * The DepartureAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: IataOrigen de la FareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirportLocationCode;
    /**
     * The Services
     * Meta information extracted from the WSDL
     * - documentation: Listado de los Servicios asociados a la FareFamilies del Segmento
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Services;
    /**
     * The ArrivalAirportLocationCode
     * Meta information extracted from the WSDL
     * - documentation: IataDestino de la FareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirportLocationCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Descripción de la FareFamilies del Segmento
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * Constructor method for AirBookingFareFamilies
     * @uses AirBookingFareFamilies::setDepartureAirportLocationCode()
     * @uses AirBookingFareFamilies::setServices()
     * @uses AirBookingFareFamilies::setArrivalAirportLocationCode()
     * @uses AirBookingFareFamilies::setDescription()
     * @param string $departureAirportLocationCode
     * @param \ArrayType\ArrayOfstring $services
     * @param string $arrivalAirportLocationCode
     * @param string $description
     */
    public function __construct($departureAirportLocationCode = null, \ArrayType\ArrayOfstring $services = null, $arrivalAirportLocationCode = null, $description = null)
    {
        $this
            ->setDepartureAirportLocationCode($departureAirportLocationCode)
            ->setServices($services)
            ->setArrivalAirportLocationCode($arrivalAirportLocationCode)
            ->setDescription($description);
    }
    /**
     * Get DepartureAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirportLocationCode()
    {
        return isset($this->DepartureAirportLocationCode) ? $this->DepartureAirportLocationCode : null;
    }
    /**
     * Set DepartureAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirportLocationCode
     * @return \StructType\AirBookingFareFamilies
     */
    public function setDepartureAirportLocationCode($departureAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirportLocationCode) && !is_string($departureAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureAirportLocationCode, true), gettype($departureAirportLocationCode)), __LINE__);
        }
        if (is_null($departureAirportLocationCode) || (is_array($departureAirportLocationCode) && empty($departureAirportLocationCode))) {
            unset($this->DepartureAirportLocationCode);
        } else {
            $this->DepartureAirportLocationCode = $departureAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get Services value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getServices()
    {
        return isset($this->Services) ? $this->Services : null;
    }
    /**
     * Set Services value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $services
     * @return \StructType\AirBookingFareFamilies
     */
    public function setServices(\ArrayType\ArrayOfstring $services = null)
    {
        if (is_null($services) || (is_array($services) && empty($services))) {
            unset($this->Services);
        } else {
            $this->Services = $services;
        }
        return $this;
    }
    /**
     * Get ArrivalAirportLocationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirportLocationCode()
    {
        return isset($this->ArrivalAirportLocationCode) ? $this->ArrivalAirportLocationCode : null;
    }
    /**
     * Set ArrivalAirportLocationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirportLocationCode
     * @return \StructType\AirBookingFareFamilies
     */
    public function setArrivalAirportLocationCode($arrivalAirportLocationCode = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirportLocationCode) && !is_string($arrivalAirportLocationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalAirportLocationCode, true), gettype($arrivalAirportLocationCode)), __LINE__);
        }
        if (is_null($arrivalAirportLocationCode) || (is_array($arrivalAirportLocationCode) && empty($arrivalAirportLocationCode))) {
            unset($this->ArrivalAirportLocationCode);
        } else {
            $this->ArrivalAirportLocationCode = $arrivalAirportLocationCode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\AirBookingFareFamilies
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
}
