<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingFare StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa una de las lineas de tarifas que componen una reserva.
 * - nillable: true
 * - type: tns:AirBookingFare
 * @subpackage Structs
 */
class AirBookingFare extends AbstractStructBase
{
    /**
     * The TravelerInfo
     * Meta information extracted from the WSDL
     * - documentation: Tipo de pasajero al que se aplica la tarifa, representado por un objeto del tipo <b>AirTravelerInfo</b>
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirTravelerInfo
     */
    public $TravelerInfo;
    /**
     * The TotalTravelers
     * Meta information extracted from the WSDL
     * - documentation: Número total de pasajeros de la reserva al que se aplica esta tarifa
     * - minOccurs: 0
     * @var int
     */
    public $TotalTravelers;
    /**
     * The FareAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de la tarifa
     * - minOccurs: 0
     * @var float
     */
    public $FareAmount;
    /**
     * The TaxAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de las tasas
     * - minOccurs: 0
     * @var float
     */
    public $TaxAmount;
    /**
     * The AramixFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de la comisión de Aramix
     * - minOccurs: 0
     * @var float
     */
    public $AramixFeeAmount;
    /**
     * The AgencyFeeAmount
     * Meta information extracted from the WSDL
     * - documentation: Importe de la comisión de la Agencia
     * - minOccurs: 0
     * @var float
     */
    public $AgencyFeeAmount;
    /**
     * Constructor method for AirBookingFare
     * @uses AirBookingFare::setTravelerInfo()
     * @uses AirBookingFare::setTotalTravelers()
     * @uses AirBookingFare::setFareAmount()
     * @uses AirBookingFare::setTaxAmount()
     * @uses AirBookingFare::setAramixFeeAmount()
     * @uses AirBookingFare::setAgencyFeeAmount()
     * @param \StructType\AirTravelerInfo $travelerInfo
     * @param int $totalTravelers
     * @param float $fareAmount
     * @param float $taxAmount
     * @param float $aramixFeeAmount
     * @param float $agencyFeeAmount
     */
    public function __construct(\StructType\AirTravelerInfo $travelerInfo = null, $totalTravelers = null, $fareAmount = null, $taxAmount = null, $aramixFeeAmount = null, $agencyFeeAmount = null)
    {
        $this
            ->setTravelerInfo($travelerInfo)
            ->setTotalTravelers($totalTravelers)
            ->setFareAmount($fareAmount)
            ->setTaxAmount($taxAmount)
            ->setAramixFeeAmount($aramixFeeAmount)
            ->setAgencyFeeAmount($agencyFeeAmount);
    }
    /**
     * Get TravelerInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirTravelerInfo|null
     */
    public function getTravelerInfo()
    {
        return isset($this->TravelerInfo) ? $this->TravelerInfo : null;
    }
    /**
     * Set TravelerInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirTravelerInfo $travelerInfo
     * @return \StructType\AirBookingFare
     */
    public function setTravelerInfo(\StructType\AirTravelerInfo $travelerInfo = null)
    {
        if (is_null($travelerInfo) || (is_array($travelerInfo) && empty($travelerInfo))) {
            unset($this->TravelerInfo);
        } else {
            $this->TravelerInfo = $travelerInfo;
        }
        return $this;
    }
    /**
     * Get TotalTravelers value
     * @return int|null
     */
    public function getTotalTravelers()
    {
        return $this->TotalTravelers;
    }
    /**
     * Set TotalTravelers value
     * @param int $totalTravelers
     * @return \StructType\AirBookingFare
     */
    public function setTotalTravelers($totalTravelers = null)
    {
        // validation for constraint: int
        if (!is_null($totalTravelers) && !(is_int($totalTravelers) || ctype_digit($totalTravelers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalTravelers, true), gettype($totalTravelers)), __LINE__);
        }
        $this->TotalTravelers = $totalTravelers;
        return $this;
    }
    /**
     * Get FareAmount value
     * @return float|null
     */
    public function getFareAmount()
    {
        return $this->FareAmount;
    }
    /**
     * Set FareAmount value
     * @param float $fareAmount
     * @return \StructType\AirBookingFare
     */
    public function setFareAmount($fareAmount = null)
    {
        // validation for constraint: float
        if (!is_null($fareAmount) && !(is_float($fareAmount) || is_numeric($fareAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fareAmount, true), gettype($fareAmount)), __LINE__);
        }
        $this->FareAmount = $fareAmount;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \StructType\AirBookingFare
     */
    public function setTaxAmount($taxAmount = null)
    {
        // validation for constraint: float
        if (!is_null($taxAmount) && !(is_float($taxAmount) || is_numeric($taxAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxAmount, true), gettype($taxAmount)), __LINE__);
        }
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Get AramixFeeAmount value
     * @return float|null
     */
    public function getAramixFeeAmount()
    {
        return $this->AramixFeeAmount;
    }
    /**
     * Set AramixFeeAmount value
     * @param float $aramixFeeAmount
     * @return \StructType\AirBookingFare
     */
    public function setAramixFeeAmount($aramixFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($aramixFeeAmount) && !(is_float($aramixFeeAmount) || is_numeric($aramixFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aramixFeeAmount, true), gettype($aramixFeeAmount)), __LINE__);
        }
        $this->AramixFeeAmount = $aramixFeeAmount;
        return $this;
    }
    /**
     * Get AgencyFeeAmount value
     * @return float|null
     */
    public function getAgencyFeeAmount()
    {
        return $this->AgencyFeeAmount;
    }
    /**
     * Set AgencyFeeAmount value
     * @param float $agencyFeeAmount
     * @return \StructType\AirBookingFare
     */
    public function setAgencyFeeAmount($agencyFeeAmount = null)
    {
        // validation for constraint: float
        if (!is_null($agencyFeeAmount) && !(is_float($agencyFeeAmount) || is_numeric($agencyFeeAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($agencyFeeAmount, true), gettype($agencyFeeAmount)), __LINE__);
        }
        $this->AgencyFeeAmount = $agencyFeeAmount;
        return $this;
    }
}
