<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirBookingAllowedBaggage StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa el equipaje permitido en una reserva de vuelo
 * - nillable: true
 * - type: tns:AirBookingAllowedBaggage
 * @subpackage Structs
 */
class AirBookingAllowedBaggage extends AbstractStructBase
{
    /**
     * The BaggageWeight
     * Meta information extracted from the WSDL
     * - documentation: Peso total permitido
     * - minOccurs: 0
     * @var float
     */
    public $BaggageWeight;
    /**
     * The MeasureUnit
     * Meta information extracted from the WSDL
     * - documentation: K:Kg, P:Pounds o Libras
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MeasureUnit;
    /**
     * The BaggageQuantity
     * Meta information extracted from the WSDL
     * - documentation: Unidades totales permitidas
     * - minOccurs: 0
     * @var int
     */
    public $BaggageQuantity;
    /**
     * The BaggageType
     * Meta information extracted from the WSDL
     * - documentation: W:Peso
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BaggageType;
    /**
     * Constructor method for AirBookingAllowedBaggage
     * @uses AirBookingAllowedBaggage::setBaggageWeight()
     * @uses AirBookingAllowedBaggage::setMeasureUnit()
     * @uses AirBookingAllowedBaggage::setBaggageQuantity()
     * @uses AirBookingAllowedBaggage::setBaggageType()
     * @param float $baggageWeight
     * @param string $measureUnit
     * @param int $baggageQuantity
     * @param string $baggageType
     */
    public function __construct($baggageWeight = null, $measureUnit = null, $baggageQuantity = null, $baggageType = null)
    {
        $this
            ->setBaggageWeight($baggageWeight)
            ->setMeasureUnit($measureUnit)
            ->setBaggageQuantity($baggageQuantity)
            ->setBaggageType($baggageType);
    }
    /**
     * Get BaggageWeight value
     * @return float|null
     */
    public function getBaggageWeight()
    {
        return $this->BaggageWeight;
    }
    /**
     * Set BaggageWeight value
     * @param float $baggageWeight
     * @return \StructType\AirBookingAllowedBaggage
     */
    public function setBaggageWeight($baggageWeight = null)
    {
        // validation for constraint: float
        if (!is_null($baggageWeight) && !(is_float($baggageWeight) || is_numeric($baggageWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baggageWeight, true), gettype($baggageWeight)), __LINE__);
        }
        $this->BaggageWeight = $baggageWeight;
        return $this;
    }
    /**
     * Get MeasureUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMeasureUnit()
    {
        return isset($this->MeasureUnit) ? $this->MeasureUnit : null;
    }
    /**
     * Set MeasureUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $measureUnit
     * @return \StructType\AirBookingAllowedBaggage
     */
    public function setMeasureUnit($measureUnit = null)
    {
        // validation for constraint: string
        if (!is_null($measureUnit) && !is_string($measureUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($measureUnit, true), gettype($measureUnit)), __LINE__);
        }
        if (is_null($measureUnit) || (is_array($measureUnit) && empty($measureUnit))) {
            unset($this->MeasureUnit);
        } else {
            $this->MeasureUnit = $measureUnit;
        }
        return $this;
    }
    /**
     * Get BaggageQuantity value
     * @return int|null
     */
    public function getBaggageQuantity()
    {
        return $this->BaggageQuantity;
    }
    /**
     * Set BaggageQuantity value
     * @param int $baggageQuantity
     * @return \StructType\AirBookingAllowedBaggage
     */
    public function setBaggageQuantity($baggageQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($baggageQuantity) && !(is_int($baggageQuantity) || ctype_digit($baggageQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baggageQuantity, true), gettype($baggageQuantity)), __LINE__);
        }
        $this->BaggageQuantity = $baggageQuantity;
        return $this;
    }
    /**
     * Get BaggageType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBaggageType()
    {
        return isset($this->BaggageType) ? $this->BaggageType : null;
    }
    /**
     * Set BaggageType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $baggageType
     * @return \StructType\AirBookingAllowedBaggage
     */
    public function setBaggageType($baggageType = null)
    {
        // validation for constraint: string
        if (!is_null($baggageType) && !is_string($baggageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($baggageType, true), gettype($baggageType)), __LINE__);
        }
        if (is_null($baggageType) || (is_array($baggageType) && empty($baggageType))) {
            unset($this->BaggageType);
        } else {
            $this->BaggageType = $baggageType;
        }
        return $this;
    }
}
