<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailLowCostBaggagePriceRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada, para recuperar el precio por pasajero, del equipaje para una reserva low cost
 * - nillable: true
 * - type: tns:AirAvailLowCostBaggagePriceRQ
 * @subpackage Structs
 */
class AirAvailLowCostBaggagePriceRQ extends AbstractStructBase
{
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda a partir de la que queremos encontrar el precio de equipaje
     * @var int
     */
    public $AvailRequestID;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del grupo de precios para el que consultaremos el precio del equipaje
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ItinerariesID
     * Meta information extracted from the WSDL
     * - documentation: Array con los identificadores de los itinerarios devueltos por la búsqueda de disponibilidad para los que consultamos el equipaje. Importante: deben ponerse todos los itinerarios que se han devuelto en la disponibilidad, es decir,
     * si la disponibilidad es ida y vuelta deben ponerse los dos. La contratación de equipaje es tanto para el vuelo de ida como para el de vuelta, no se permite la contratación en un solo sentido.
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $ItinerariesID;
    /**
     * Constructor method for AirAvailLowCostBaggagePriceRQ
     * @uses AirAvailLowCostBaggagePriceRQ::setAvailRequestID()
     * @uses AirAvailLowCostBaggagePriceRQ::setPricingGroupID()
     * @uses AirAvailLowCostBaggagePriceRQ::setItinerariesID()
     * @param int $availRequestID
     * @param int $pricingGroupID
     * @param \ArrayType\ArrayOfInt $itinerariesID
     */
    public function __construct($availRequestID = null, $pricingGroupID = null, \ArrayType\ArrayOfInt $itinerariesID = null)
    {
        $this
            ->setAvailRequestID($availRequestID)
            ->setPricingGroupID($pricingGroupID)
            ->setItinerariesID($itinerariesID);
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirAvailLowCostBaggagePriceRQ
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirAvailLowCostBaggagePriceRQ
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ItinerariesID value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItinerariesID()
    {
        return $this->ItinerariesID;
    }
    /**
     * Set ItinerariesID value
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @return \StructType\AirAvailLowCostBaggagePriceRQ
     */
    public function setItinerariesID(\ArrayType\ArrayOfInt $itinerariesID = null)
    {
        $this->ItinerariesID = $itinerariesID;
        return $this;
    }
}
