<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailFareFamiliesRQ StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa los datos de entrada, para recuperar las FareFamilies asociadas a una combinación de vuelos
 * - nillable: true
 * - type: tns:AirAvailFareFamiliesRQ
 * @subpackage Structs
 */
class AirAvailFareFamiliesRQ extends AbstractStructBase
{
    /**
     * The AvailRequestID
     * Meta information extracted from the WSDL
     * - documentation: Identificación de la peticion de los resultados de busqueda
     * @var int
     */
    public $AvailRequestID;
    /**
     * The PricingGroupID
     * Meta information extracted from the WSDL
     * - documentation: Identificador del esquema de precio
     * @var int
     */
    public $PricingGroupID;
    /**
     * The ItinerariesID
     * Meta information extracted from the WSDL
     * - documentation: Array con los identificadores de los itinerarios devueltos por la búsqueda de disponibilidad para los que consultamos las FF Importante: deben ponerse todos los itinerarios que se han devuelto en la disponibilidad, es decir, si la
     * disponibilidad es ida y vuelta deben ponerse los dos.
     * - nillable: true
     * @var \ArrayType\ArrayOfInt
     */
    public $ItinerariesID;
    /**
     * The AdultNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de adultos
     * - minOccurs: 0
     * @var int
     */
    public $AdultNumber;
    /**
     * The ChildrenNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de Niños
     * - minOccurs: 0
     * @var int
     */
    public $ChildrenNumber;
    /**
     * The InfantNumber
     * Meta information extracted from the WSDL
     * - documentation: Indica el Numero de Bebes
     * - minOccurs: 0
     * @var int
     */
    public $InfantNumber;
    /**
     * Constructor method for AirAvailFareFamiliesRQ
     * @uses AirAvailFareFamiliesRQ::setAvailRequestID()
     * @uses AirAvailFareFamiliesRQ::setPricingGroupID()
     * @uses AirAvailFareFamiliesRQ::setItinerariesID()
     * @uses AirAvailFareFamiliesRQ::setAdultNumber()
     * @uses AirAvailFareFamiliesRQ::setChildrenNumber()
     * @uses AirAvailFareFamiliesRQ::setInfantNumber()
     * @param int $availRequestID
     * @param int $pricingGroupID
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @param int $adultNumber
     * @param int $childrenNumber
     * @param int $infantNumber
     */
    public function __construct($availRequestID = null, $pricingGroupID = null, \ArrayType\ArrayOfInt $itinerariesID = null, $adultNumber = null, $childrenNumber = null, $infantNumber = null)
    {
        $this
            ->setAvailRequestID($availRequestID)
            ->setPricingGroupID($pricingGroupID)
            ->setItinerariesID($itinerariesID)
            ->setAdultNumber($adultNumber)
            ->setChildrenNumber($childrenNumber)
            ->setInfantNumber($infantNumber);
    }
    /**
     * Get AvailRequestID value
     * @return int|null
     */
    public function getAvailRequestID()
    {
        return $this->AvailRequestID;
    }
    /**
     * Set AvailRequestID value
     * @param int $availRequestID
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setAvailRequestID($availRequestID = null)
    {
        // validation for constraint: int
        if (!is_null($availRequestID) && !(is_int($availRequestID) || ctype_digit($availRequestID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availRequestID, true), gettype($availRequestID)), __LINE__);
        }
        $this->AvailRequestID = $availRequestID;
        return $this;
    }
    /**
     * Get PricingGroupID value
     * @return int|null
     */
    public function getPricingGroupID()
    {
        return $this->PricingGroupID;
    }
    /**
     * Set PricingGroupID value
     * @param int $pricingGroupID
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setPricingGroupID($pricingGroupID = null)
    {
        // validation for constraint: int
        if (!is_null($pricingGroupID) && !(is_int($pricingGroupID) || ctype_digit($pricingGroupID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingGroupID, true), gettype($pricingGroupID)), __LINE__);
        }
        $this->PricingGroupID = $pricingGroupID;
        return $this;
    }
    /**
     * Get ItinerariesID value
     * @return \ArrayType\ArrayOfInt|null
     */
    public function getItinerariesID()
    {
        return $this->ItinerariesID;
    }
    /**
     * Set ItinerariesID value
     * @param \ArrayType\ArrayOfInt $itinerariesID
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setItinerariesID(\ArrayType\ArrayOfInt $itinerariesID = null)
    {
        $this->ItinerariesID = $itinerariesID;
        return $this;
    }
    /**
     * Get AdultNumber value
     * @return int|null
     */
    public function getAdultNumber()
    {
        return $this->AdultNumber;
    }
    /**
     * Set AdultNumber value
     * @param int $adultNumber
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setAdultNumber($adultNumber = null)
    {
        // validation for constraint: int
        if (!is_null($adultNumber) && !(is_int($adultNumber) || ctype_digit($adultNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($adultNumber, true), gettype($adultNumber)), __LINE__);
        }
        $this->AdultNumber = $adultNumber;
        return $this;
    }
    /**
     * Get ChildrenNumber value
     * @return int|null
     */
    public function getChildrenNumber()
    {
        return $this->ChildrenNumber;
    }
    /**
     * Set ChildrenNumber value
     * @param int $childrenNumber
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setChildrenNumber($childrenNumber = null)
    {
        // validation for constraint: int
        if (!is_null($childrenNumber) && !(is_int($childrenNumber) || ctype_digit($childrenNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($childrenNumber, true), gettype($childrenNumber)), __LINE__);
        }
        $this->ChildrenNumber = $childrenNumber;
        return $this;
    }
    /**
     * Get InfantNumber value
     * @return int|null
     */
    public function getInfantNumber()
    {
        return $this->InfantNumber;
    }
    /**
     * Set InfantNumber value
     * @param int $infantNumber
     * @return \StructType\AirAvailFareFamiliesRQ
     */
    public function setInfantNumber($infantNumber = null)
    {
        // validation for constraint: int
        if (!is_null($infantNumber) && !(is_int($infantNumber) || ctype_digit($infantNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($infantNumber, true), gettype($infantNumber)), __LINE__);
        }
        $this->InfantNumber = $infantNumber;
        return $this;
    }
}
