<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvailFareFamiliesOptions StructType
 * Meta information extracted from the WSDL
 * - documentation: Objeto auxiliar para contener las opciones de FareFamilies
 * - nillable: true
 * - type: tns:AirAvailFareFamiliesOptions
 * @subpackage Structs
 */
class AirAvailFareFamiliesOptions extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta information extracted from the WSDL
     * - documentation: Estructura que almacena la información de vuelos asociada a la opción de FareFamilies
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirFareFamiliesFlightSegment
     */
    public $FlightSegment;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Estructura que almacena la descripción de la FareFamilies asociada a la opción
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Description;
    /**
     * The CurrencyPrices
     * Meta information extracted from the WSDL
     * - documentation: En esta lista vendrán los importes de la FF seleccionada
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AirFareFamiliesPrice
     */
    public $CurrencyPrices;
    /**
     * Constructor method for AirAvailFareFamiliesOptions
     * @uses AirAvailFareFamiliesOptions::setFlightSegment()
     * @uses AirAvailFareFamiliesOptions::setDescription()
     * @uses AirAvailFareFamiliesOptions::setCurrencyPrices()
     * @param \ArrayType\ArrayOfAirFareFamiliesFlightSegment $flightSegment
     * @param \ArrayType\ArrayOfstring $description
     * @param \StructType\AirFareFamiliesPrice $currencyPrices
     */
    public function __construct(\ArrayType\ArrayOfAirFareFamiliesFlightSegment $flightSegment = null, \ArrayType\ArrayOfstring $description = null, \StructType\AirFareFamiliesPrice $currencyPrices = null)
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setDescription($description)
            ->setCurrencyPrices($currencyPrices);
    }
    /**
     * Get FlightSegment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirFareFamiliesFlightSegment|null
     */
    public function getFlightSegment()
    {
        return isset($this->FlightSegment) ? $this->FlightSegment : null;
    }
    /**
     * Set FlightSegment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirFareFamiliesFlightSegment $flightSegment
     * @return \StructType\AirAvailFareFamiliesOptions
     */
    public function setFlightSegment(\ArrayType\ArrayOfAirFareFamiliesFlightSegment $flightSegment = null)
    {
        if (is_null($flightSegment) || (is_array($flightSegment) && empty($flightSegment))) {
            unset($this->FlightSegment);
        } else {
            $this->FlightSegment = $flightSegment;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $description
     * @return \StructType\AirAvailFareFamiliesOptions
     */
    public function setDescription(\ArrayType\ArrayOfstring $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get CurrencyPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AirFareFamiliesPrice|null
     */
    public function getCurrencyPrices()
    {
        return isset($this->CurrencyPrices) ? $this->CurrencyPrices : null;
    }
    /**
     * Set CurrencyPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AirFareFamiliesPrice $currencyPrices
     * @return \StructType\AirAvailFareFamiliesOptions
     */
    public function setCurrencyPrices(\StructType\AirFareFamiliesPrice $currencyPrices = null)
    {
        if (is_null($currencyPrices) || (is_array($currencyPrices) && empty($currencyPrices))) {
            unset($this->CurrencyPrices);
        } else {
            $this->CurrencyPrices = $currencyPrices;
        }
        return $this;
    }
}
