<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirAvail StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase que representa el resultado de una búsqueda de vuelos
 * - nillable: true
 * - type: tns:AirAvail
 * @subpackage Structs
 */
class AirAvail extends AbstractStructBase
{
    /**
     * The AirTravelersInfo
     * Meta information extracted from the WSDL
     * - documentation: Lista de pasajeros junto con sus caracteristicas especiales, tipo de pasajero y si es residente. Array de objetos <b>AirTravelerInfo</b>.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirTravelerInfo
     */
    public $AirTravelersInfo;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - documentation: Lista de warnings devueltos por el motor. No implican error y deberían mostrarse en la interfaz de usuario
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfWarning
     */
    public $Warnings;
    /**
     * The AirItineraries
     * Meta information extracted from the WSDL
     * - documentation: Lista de Itinerarios que componen esta disponibilidad. Array de objetos <b>AirItinerary</b>.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirItinerary
     */
    public $AirItineraries;
    /**
     * The AirPricingGroups
     * Meta information extracted from the WSDL
     * - documentation: Lista de grupos de precios que componen esta disponibilidad. Array de objetos <b>AirPricingGroup</b>.
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirPricingGroup
     */
    public $AirPricingGroups;
    /**
     * The AirCalendarCombinations
     * Meta information extracted from the WSDL
     * - documentation: Combinaciones de precios para la busqueda por calendario (propiedad devuelta solo en caso de buscar por calendario). Array de objetos <b>AirCalendarCombination</b>
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAirCalendarCombination
     */
    public $AirCalendarCombinations;
    /**
     * Constructor method for AirAvail
     * @uses AirAvail::setAirTravelersInfo()
     * @uses AirAvail::setWarnings()
     * @uses AirAvail::setAirItineraries()
     * @uses AirAvail::setAirPricingGroups()
     * @uses AirAvail::setAirCalendarCombinations()
     * @param \ArrayType\ArrayOfAirTravelerInfo $airTravelersInfo
     * @param \ArrayType\ArrayOfWarning $warnings
     * @param \ArrayType\ArrayOfAirItinerary $airItineraries
     * @param \ArrayType\ArrayOfAirPricingGroup $airPricingGroups
     * @param \ArrayType\ArrayOfAirCalendarCombination $airCalendarCombinations
     */
    public function __construct(\ArrayType\ArrayOfAirTravelerInfo $airTravelersInfo = null, \ArrayType\ArrayOfWarning $warnings = null, \ArrayType\ArrayOfAirItinerary $airItineraries = null, \ArrayType\ArrayOfAirPricingGroup $airPricingGroups = null, \ArrayType\ArrayOfAirCalendarCombination $airCalendarCombinations = null)
    {
        $this
            ->setAirTravelersInfo($airTravelersInfo)
            ->setWarnings($warnings)
            ->setAirItineraries($airItineraries)
            ->setAirPricingGroups($airPricingGroups)
            ->setAirCalendarCombinations($airCalendarCombinations);
    }
    /**
     * Get AirTravelersInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirTravelerInfo|null
     */
    public function getAirTravelersInfo()
    {
        return isset($this->AirTravelersInfo) ? $this->AirTravelersInfo : null;
    }
    /**
     * Set AirTravelersInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirTravelerInfo $airTravelersInfo
     * @return \StructType\AirAvail
     */
    public function setAirTravelersInfo(\ArrayType\ArrayOfAirTravelerInfo $airTravelersInfo = null)
    {
        if (is_null($airTravelersInfo) || (is_array($airTravelersInfo) && empty($airTravelersInfo))) {
            unset($this->AirTravelersInfo);
        } else {
            $this->AirTravelersInfo = $airTravelersInfo;
        }
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfWarning|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfWarning $warnings
     * @return \StructType\AirAvail
     */
    public function setWarnings(\ArrayType\ArrayOfWarning $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
    /**
     * Get AirItineraries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirItinerary|null
     */
    public function getAirItineraries()
    {
        return isset($this->AirItineraries) ? $this->AirItineraries : null;
    }
    /**
     * Set AirItineraries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirItinerary $airItineraries
     * @return \StructType\AirAvail
     */
    public function setAirItineraries(\ArrayType\ArrayOfAirItinerary $airItineraries = null)
    {
        if (is_null($airItineraries) || (is_array($airItineraries) && empty($airItineraries))) {
            unset($this->AirItineraries);
        } else {
            $this->AirItineraries = $airItineraries;
        }
        return $this;
    }
    /**
     * Get AirPricingGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirPricingGroup|null
     */
    public function getAirPricingGroups()
    {
        return isset($this->AirPricingGroups) ? $this->AirPricingGroups : null;
    }
    /**
     * Set AirPricingGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirPricingGroup $airPricingGroups
     * @return \StructType\AirAvail
     */
    public function setAirPricingGroups(\ArrayType\ArrayOfAirPricingGroup $airPricingGroups = null)
    {
        if (is_null($airPricingGroups) || (is_array($airPricingGroups) && empty($airPricingGroups))) {
            unset($this->AirPricingGroups);
        } else {
            $this->AirPricingGroups = $airPricingGroups;
        }
        return $this;
    }
    /**
     * Get AirCalendarCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAirCalendarCombination|null
     */
    public function getAirCalendarCombinations()
    {
        return isset($this->AirCalendarCombinations) ? $this->AirCalendarCombinations : null;
    }
    /**
     * Set AirCalendarCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAirCalendarCombination $airCalendarCombinations
     * @return \StructType\AirAvail
     */
    public function setAirCalendarCombinations(\ArrayType\ArrayOfAirCalendarCombination $airCalendarCombinations = null)
    {
        if (is_null($airCalendarCombinations) || (is_array($airCalendarCombinations) && empty($airCalendarCombinations))) {
            unset($this->AirCalendarCombinations);
        } else {
            $this->AirCalendarCombinations = $airCalendarCombinations;
        }
        return $this;
    }
}
