<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgencyCardsListRS StructType
 * Meta information extracted from the WSDL
 * - documentation: Clase con el response de las tarjetas dadas de alta en el sistema, de una agencia para pago UYU
 * - nillable: true
 * - type: tns:AgencyCardsListRS
 * @subpackage Structs
 */
class AgencyCardsListRS extends AbstractStructBase
{
    /**
     * The AgencyCards
     * Meta information extracted from the WSDL
     * - documentation: Lista de las tarjetas de la agencia
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAgencyCard
     */
    public $AgencyCards;
    /**
     * Constructor method for AgencyCardsListRS
     * @uses AgencyCardsListRS::setAgencyCards()
     * @param \ArrayType\ArrayOfAgencyCard $agencyCards
     */
    public function __construct(\ArrayType\ArrayOfAgencyCard $agencyCards = null)
    {
        $this
            ->setAgencyCards($agencyCards);
    }
    /**
     * Get AgencyCards value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAgencyCard|null
     */
    public function getAgencyCards()
    {
        return isset($this->AgencyCards) ? $this->AgencyCards : null;
    }
    /**
     * Set AgencyCards value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAgencyCard $agencyCards
     * @return \StructType\AgencyCardsListRS
     */
    public function setAgencyCards(\ArrayType\ArrayOfAgencyCard $agencyCards = null)
    {
        if (is_null($agencyCards) || (is_array($agencyCards) && empty($agencyCards))) {
            unset($this->AgencyCards);
        } else {
            $this->AgencyCards = $agencyCards;
        }
        return $this;
    }
}
