<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirBookingStatus EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumeracion con los distintos estados de la reserva
 * - nillable: true
 * - type: tns:AirBookingStatus
 * @subpackage Enumerations
 */
class AirBookingStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'INI'
     * Meta information extracted from the WSDL
     * - documentation: Indica que se ha iniciado una nueva reserva
     * @return string 'INI'
     */
    const VALUE_INI = 'INI';
    /**
     * Constant for value 'RES'
     * Meta information extracted from the WSDL
     * - documentation: la reserva tiene localizador y está lista para emitir los billetes
     * @return string 'RES'
     */
    const VALUE_RES = 'RES';
    /**
     * Constant for value 'BEM'
     * Meta information extracted from the WSDL
     * - documentation: Indica que los billetes han sido emitido
     * @return string 'BEM'
     */
    const VALUE_BEM = 'BEM';
    /**
     * Constant for value 'BCN'
     * Meta information extracted from the WSDL
     * - documentation: Indica que los billetes han sido cancelados y la reserva ha sido cancelada
     * @return string 'BCN'
     */
    const VALUE_BCN = 'BCN';
    /**
     * Constant for value 'CAN'
     * Meta information extracted from the WSDL
     * - documentation: La reserva ha sido cancelada antes de emitir el billete
     * @return string 'CAN'
     */
    const VALUE_CAN = 'CAN';
    /**
     * Constant for value 'RLE'
     * Meta information extracted from the WSDL
     * - documentation: Reserva Lista para Emitir
     * @return string 'RLE'
     */
    const VALUE_RLE = 'RLE';
    /**
     * Return allowed values
     * @uses self::VALUE_INI
     * @uses self::VALUE_RES
     * @uses self::VALUE_BEM
     * @uses self::VALUE_BCN
     * @uses self::VALUE_CAN
     * @uses self::VALUE_RLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INI,
            self::VALUE_RES,
            self::VALUE_BEM,
            self::VALUE_BCN,
            self::VALUE_CAN,
            self::VALUE_RLE,
        );
    }
}
