<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for AirBookingSearchSortFields EnumType
 * Meta information extracted from the WSDL
 * - documentation: Enumera los campos para los que se puede ordenar un listado de reservas
 * - nillable: true
 * - type: tns:AirBookingSearchSortFields
 * @subpackage Enumerations
 */
class AirBookingSearchSortFields extends AbstractStructEnumBase
{
    /**
     * Constant for value 'None'
     * Meta information extracted from the WSDL
     * - documentation: Ordenación no establecida
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'BookingId'
     * Meta information extracted from the WSDL
     * - documentation: Identificador interno de la reserva
     * @return string 'BookingId'
     */
    const VALUE_BOOKING_ID = 'BookingId';
    /**
     * Constant for value 'BookingReference'
     * Meta information extracted from the WSDL
     * - documentation: Localizador de la reserva
     * @return string 'BookingReference'
     */
    const VALUE_BOOKING_REFERENCE = 'BookingReference';
    /**
     * Constant for value 'BookingStatus'
     * Meta information extracted from the WSDL
     * - documentation: Estado de la reserva
     * @return string 'BookingStatus'
     */
    const VALUE_BOOKING_STATUS = 'BookingStatus';
    /**
     * Constant for value 'BookingDate'
     * Meta information extracted from the WSDL
     * - documentation: Fecha de la reserva
     * @return string 'BookingDate'
     */
    const VALUE_BOOKING_DATE = 'BookingDate';
    /**
     * Constant for value 'DeadLineDate'
     * Meta information extracted from the WSDL
     * - documentation: Fecha limite de la reserva
     * @return string 'DeadLineDate'
     */
    const VALUE_DEAD_LINE_DATE = 'DeadLineDate';
    /**
     * Constant for value 'TotalAmount'
     * Meta information extracted from the WSDL
     * - documentation: Precio total de la Reserva
     * @return string 'TotalAmount'
     */
    const VALUE_TOTAL_AMOUNT = 'TotalAmount';
    /**
     * Constant for value 'CancellationInsurance'
     * Meta information extracted from the WSDL
     * - documentation: Indica si tiene o no seguro de cancelacion
     * @return string 'CancellationInsurance'
     */
    const VALUE_CANCELLATION_INSURANCE = 'CancellationInsurance';
    /**
     * Constant for value 'PaymentForm'
     * Meta information extracted from the WSDL
     * - documentation: Forma de pago de la reserva
     * @return string 'PaymentForm'
     */
    const VALUE_PAYMENT_FORM = 'PaymentForm';
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_BOOKING_ID
     * @uses self::VALUE_BOOKING_REFERENCE
     * @uses self::VALUE_BOOKING_STATUS
     * @uses self::VALUE_BOOKING_DATE
     * @uses self::VALUE_DEAD_LINE_DATE
     * @uses self::VALUE_TOTAL_AMOUNT
     * @uses self::VALUE_CANCELLATION_INSURANCE
     * @uses self::VALUE_PAYMENT_FORM
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_BOOKING_ID,
            self::VALUE_BOOKING_REFERENCE,
            self::VALUE_BOOKING_STATUS,
            self::VALUE_BOOKING_DATE,
            self::VALUE_DEAD_LINE_DATE,
            self::VALUE_TOTAL_AMOUNT,
            self::VALUE_CANCELLATION_INSURANCE,
            self::VALUE_PAYMENT_FORM,
        );
    }
}
