<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TipSuma StructType
 * @subpackage Structs
 */
class TipSuma extends AbstractStructBase
{
    /**
     * The idTipSuma
     * @var int
     */
    public $idTipSuma;
    /**
     * The valoare
     * @var float
     */
    public $valoare;
    /**
     * The prioritate
     * @var int
     */
    public $prioritate;
    /**
     * The detaliiHeader
     * @var \ArrayType\ArrayOfString
     */
    public $detaliiHeader;
    /**
     * The detaliiBody
     * @var \ArrayType\ArrayOfLiniedetaliisume
     */
    public $detaliiBody;
    /**
     * Constructor method for TipSuma
     * @uses TipSuma::setIdTipSuma()
     * @uses TipSuma::setValoare()
     * @uses TipSuma::setPrioritate()
     * @uses TipSuma::setDetaliiHeader()
     * @uses TipSuma::setDetaliiBody()
     * @param int $idTipSuma
     * @param float $valoare
     * @param int $prioritate
     * @param \ArrayType\ArrayOfString $detaliiHeader
     * @param \ArrayType\ArrayOfLiniedetaliisume $detaliiBody
     */
    public function __construct($idTipSuma = null, $valoare = null, $prioritate = null, \ArrayType\ArrayOfString $detaliiHeader = null, \ArrayType\ArrayOfLiniedetaliisume $detaliiBody = null)
    {
        $this
            ->setIdTipSuma($idTipSuma)
            ->setValoare($valoare)
            ->setPrioritate($prioritate)
            ->setDetaliiHeader($detaliiHeader)
            ->setDetaliiBody($detaliiBody);
    }
    /**
     * Get idTipSuma value
     * @return int|null
     */
    public function getIdTipSuma()
    {
        return $this->idTipSuma;
    }
    /**
     * Set idTipSuma value
     * @param int $idTipSuma
     * @return \StructType\TipSuma
     */
    public function setIdTipSuma($idTipSuma = null)
    {
        // validation for constraint: int
        if (!is_null($idTipSuma) && !(is_int($idTipSuma) || ctype_digit($idTipSuma))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTipSuma, true), gettype($idTipSuma)), __LINE__);
        }
        $this->idTipSuma = $idTipSuma;
        return $this;
    }
    /**
     * Get valoare value
     * @return float|null
     */
    public function getValoare()
    {
        return $this->valoare;
    }
    /**
     * Set valoare value
     * @param float $valoare
     * @return \StructType\TipSuma
     */
    public function setValoare($valoare = null)
    {
        // validation for constraint: float
        if (!is_null($valoare) && !(is_float($valoare) || is_numeric($valoare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valoare, true), gettype($valoare)), __LINE__);
        }
        $this->valoare = $valoare;
        return $this;
    }
    /**
     * Get prioritate value
     * @return int|null
     */
    public function getPrioritate()
    {
        return $this->prioritate;
    }
    /**
     * Set prioritate value
     * @param int $prioritate
     * @return \StructType\TipSuma
     */
    public function setPrioritate($prioritate = null)
    {
        // validation for constraint: int
        if (!is_null($prioritate) && !(is_int($prioritate) || ctype_digit($prioritate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($prioritate, true), gettype($prioritate)), __LINE__);
        }
        $this->prioritate = $prioritate;
        return $this;
    }
    /**
     * Get detaliiHeader value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getDetaliiHeader()
    {
        return $this->detaliiHeader;
    }
    /**
     * Set detaliiHeader value
     * @param \ArrayType\ArrayOfString $detaliiHeader
     * @return \StructType\TipSuma
     */
    public function setDetaliiHeader(\ArrayType\ArrayOfString $detaliiHeader = null)
    {
        $this->detaliiHeader = $detaliiHeader;
        return $this;
    }
    /**
     * Get detaliiBody value
     * @return \ArrayType\ArrayOfLiniedetaliisume|null
     */
    public function getDetaliiBody()
    {
        return $this->detaliiBody;
    }
    /**
     * Set detaliiBody value
     * @param \ArrayType\ArrayOfLiniedetaliisume $detaliiBody
     * @return \StructType\TipSuma
     */
    public function setDetaliiBody(\ArrayType\ArrayOfLiniedetaliisume $detaliiBody = null)
    {
        $this->detaliiBody = $detaliiBody;
        return $this;
    }
}
