<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SumaIncasata StructType
 * @subpackage Structs
 */
class SumaIncasata extends AbstractStructBase
{
    /**
     * The idTipSuma
     * @var int
     */
    public $idTipSuma;
    /**
     * The valoare
     * @var float
     */
    public $valoare;
    /**
     * Constructor method for SumaIncasata
     * @uses SumaIncasata::setIdTipSuma()
     * @uses SumaIncasata::setValoare()
     * @param int $idTipSuma
     * @param float $valoare
     */
    public function __construct($idTipSuma = null, $valoare = null)
    {
        $this
            ->setIdTipSuma($idTipSuma)
            ->setValoare($valoare);
    }
    /**
     * Get idTipSuma value
     * @return int|null
     */
    public function getIdTipSuma()
    {
        return $this->idTipSuma;
    }
    /**
     * Set idTipSuma value
     * @param int $idTipSuma
     * @return \StructType\SumaIncasata
     */
    public function setIdTipSuma($idTipSuma = null)
    {
        // validation for constraint: int
        if (!is_null($idTipSuma) && !(is_int($idTipSuma) || ctype_digit($idTipSuma))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idTipSuma, true), gettype($idTipSuma)), __LINE__);
        }
        $this->idTipSuma = $idTipSuma;
        return $this;
    }
    /**
     * Get valoare value
     * @return float|null
     */
    public function getValoare()
    {
        return $this->valoare;
    }
    /**
     * Set valoare value
     * @param float $valoare
     * @return \StructType\SumaIncasata
     */
    public function setValoare($valoare = null)
    {
        // validation for constraint: float
        if (!is_null($valoare) && !(is_float($valoare) || is_numeric($valoare))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valoare, true), gettype($valoare)), __LINE__);
        }
        $this->valoare = $valoare;
        return $this;
    }
}
