<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for inregistrareIncasari StructType
 * @subpackage Structs
 */
class InregistrareIncasari extends AbstractStructBase
{
    /**
     * The order
     * @var int
     */
    public $order;
    /**
     * The cui
     * @var string
     */
    public $cui;
    /**
     * The sume
     * @var \ArrayType\ArrayOfSumaincasata
     */
    public $sume;
    /**
     * The data
     * @var string
     */
    public $data;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * The check
     * @var string
     */
    public $check;
    /**
     * Constructor method for inregistrareIncasari
     * @uses InregistrareIncasari::setOrder()
     * @uses InregistrareIncasari::setCui()
     * @uses InregistrareIncasari::setSume()
     * @uses InregistrareIncasari::setData()
     * @uses InregistrareIncasari::setTimestamp()
     * @uses InregistrareIncasari::setCheck()
     * @param int $order
     * @param string $cui
     * @param \ArrayType\ArrayOfSumaincasata $sume
     * @param string $data
     * @param string $timestamp
     * @param string $check
     */
    public function __construct($order = null, $cui = null, \ArrayType\ArrayOfSumaincasata $sume = null, $data = null, $timestamp = null, $check = null)
    {
        $this
            ->setOrder($order)
            ->setCui($cui)
            ->setSume($sume)
            ->setData($data)
            ->setTimestamp($timestamp)
            ->setCheck($check);
    }
    /**
     * Get order value
     * @return int|null
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \StructType\InregistrareIncasari
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get cui value
     * @return string|null
     */
    public function getCui()
    {
        return $this->cui;
    }
    /**
     * Set cui value
     * @param string $cui
     * @return \StructType\InregistrareIncasari
     */
    public function setCui($cui = null)
    {
        // validation for constraint: string
        if (!is_null($cui) && !is_string($cui)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cui, true), gettype($cui)), __LINE__);
        }
        $this->cui = $cui;
        return $this;
    }
    /**
     * Get sume value
     * @return \ArrayType\ArrayOfSumaincasata|null
     */
    public function getSume()
    {
        return $this->sume;
    }
    /**
     * Set sume value
     * @param \ArrayType\ArrayOfSumaincasata $sume
     * @return \StructType\InregistrareIncasari
     */
    public function setSume(\ArrayType\ArrayOfSumaincasata $sume = null)
    {
        $this->sume = $sume;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\InregistrareIncasari
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\InregistrareIncasari
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get check value
     * @return string|null
     */
    public function getCheck()
    {
        return $this->check;
    }
    /**
     * Set check value
     * @param string $check
     * @return \StructType\InregistrareIncasari
     */
    public function setCheck($check = null)
    {
        // validation for constraint: string
        if (!is_null($check) && !is_string($check)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($check, true), gettype($check)), __LINE__);
        }
        $this->check = $check;
        return $this;
    }
}
