<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Inregistrare ServiceType
 * @subpackage Services
 */
class Inregistrare extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named inregistrareIncasari
     * Meta information extracted from the WSDL
     * - documentation: Metoda care primeste sumele si tipurile pentru care s-a facut plata pe un CUI
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InregistrareIncasari $parameters
     * @return \StructType\InregistrareIncasariResponse|bool
     */
    public function inregistrareIncasari(\StructType\InregistrareIncasari $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->inregistrareIncasari($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InregistrareIncasariResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
