<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getSumeDePlataPePersoana
     * Meta information extracted from the WSDL
     * - documentation: Metoda care returneaza sumele de plata cu detaliile acestora pentru un CUI dat
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSumeDePlataPePersoana $parameters
     * @return \StructType\GetSumeDePlataPePersoanaResponse|bool
     */
    public function getSumeDePlataPePersoana(\StructType\GetSumeDePlataPePersoana $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getSumeDePlataPePersoana($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetSumeDePlataPePersoanaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
