<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PitchStatusEvent StructType
 * @subpackage Structs
 */
class PitchStatusEvent extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The Pitch
     * @var int
     */
    public $Pitch;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The presence
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $presence;
    /**
     * Constructor method for PitchStatusEvent
     * @uses PitchStatusEvent::setId()
     * @uses PitchStatusEvent::setPitch()
     * @uses PitchStatusEvent::setStatus()
     * @uses PitchStatusEvent::setPresence()
     * @param string $id
     * @param int $pitch
     * @param string $status
     * @param string $presence
     */
    public function __construct($id = null, $pitch = null, $status = null, $presence = null)
    {
        $this
            ->setId($id)
            ->setPitch($pitch)
            ->setStatus($status)
            ->setPresence($presence);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\PitchStatusEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Pitch value
     * @return int|null
     */
    public function getPitch()
    {
        return $this->Pitch;
    }
    /**
     * Set Pitch value
     * @param int $pitch
     * @return \StructType\PitchStatusEvent
     */
    public function setPitch($pitch = null)
    {
        // validation for constraint: int
        if (!is_null($pitch) && !(is_int($pitch) || ctype_digit($pitch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pitch, true), gettype($pitch)), __LINE__);
        }
        $this->Pitch = $pitch;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\PitchStatusCode::valueIsValid()
     * @uses \EnumType\PitchStatusCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\PitchStatusEvent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PitchStatusCode::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PitchStatusCode', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\PitchStatusCode::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get presence value
     * @return string|null
     */
    public function getPresence()
    {
        return $this->presence;
    }
    /**
     * Set presence value
     * @uses \EnumType\PitchPresenceCode::valueIsValid()
     * @uses \EnumType\PitchPresenceCode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $presence
     * @return \StructType\PitchStatusEvent
     */
    public function setPresence($presence = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PitchPresenceCode::valueIsValid($presence)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PitchPresenceCode', is_array($presence) ? implode(', ', $presence) : var_export($presence, true), implode(', ', \EnumType\PitchPresenceCode::getValidValues())), __LINE__);
        }
        $this->presence = $presence;
        return $this;
    }
}
