<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Charge ServiceType
 * @subpackage Services
 */
class Charge extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named chargeEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ChargeEvent $parameters
     * @return \StructType\ChargeEventResponse|bool
     */
    public function chargeEvent(\StructType\ChargeEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->chargeEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ChargeEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
