<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Call ServiceType
 * @subpackage Services
 */
class Call extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named callChargeEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CallChargeEvent $parameters
     * @return \StructType\CallChargeEventResponse|bool
     */
    public function callChargeEvent(\StructType\CallChargeEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->callChargeEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CallChargeEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
