<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for messageEvent StructType
 * @subpackage Structs
 */
class MessageEvent extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The Pitch
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Pitch;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The alarm
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $alarm;
    /**
     * The deactivation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $deactivation;
    /**
     * The message
     * @var string
     */
    public $message;
    /**
     * Constructor method for messageEvent
     * @uses MessageEvent::setId()
     * @uses MessageEvent::setPitch()
     * @uses MessageEvent::setType()
     * @uses MessageEvent::setAlarm()
     * @uses MessageEvent::setDeactivation()
     * @uses MessageEvent::setMessage()
     * @param string $id
     * @param int $pitch
     * @param string $type
     * @param bool $alarm
     * @param bool $deactivation
     * @param string $message
     */
    public function __construct($id = null, $pitch = null, $type = null, $alarm = null, $deactivation = null, $message = null)
    {
        $this
            ->setId($id)
            ->setPitch($pitch)
            ->setType($type)
            ->setAlarm($alarm)
            ->setDeactivation($deactivation)
            ->setMessage($message);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\MessageEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Pitch value
     * @return int|null
     */
    public function getPitch()
    {
        return $this->Pitch;
    }
    /**
     * Set Pitch value
     * @param int $pitch
     * @return \StructType\MessageEvent
     */
    public function setPitch($pitch = null)
    {
        // validation for constraint: int
        if (!is_null($pitch) && !(is_int($pitch) || ctype_digit($pitch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pitch, true), gettype($pitch)), __LINE__);
        }
        $this->Pitch = $pitch;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\MessageType::valueIsValid()
     * @uses \EnumType\MessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\MessageEvent
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MessageType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\MessageType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\MessageType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get alarm value
     * @return bool|null
     */
    public function getAlarm()
    {
        return $this->alarm;
    }
    /**
     * Set alarm value
     * @param bool $alarm
     * @return \StructType\MessageEvent
     */
    public function setAlarm($alarm = null)
    {
        // validation for constraint: boolean
        if (!is_null($alarm) && !is_bool($alarm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alarm, true), gettype($alarm)), __LINE__);
        }
        $this->alarm = $alarm;
        return $this;
    }
    /**
     * Get deactivation value
     * @return bool|null
     */
    public function getDeactivation()
    {
        return $this->deactivation;
    }
    /**
     * Set deactivation value
     * @param bool $deactivation
     * @return \StructType\MessageEvent
     */
    public function setDeactivation($deactivation = null)
    {
        // validation for constraint: boolean
        if (!is_null($deactivation) && !is_bool($deactivation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($deactivation, true), gettype($deactivation)), __LINE__);
        }
        $this->deactivation = $deactivation;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\MessageEvent
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
}
