<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for chargeEvent StructType
 * @subpackage Structs
 */
class ChargeEvent extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The Pitch
     * @var int
     */
    public $Pitch;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $time;
    /**
     * The code
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $code;
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $price;
    /**
     * The discountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $discountPercent;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * The info
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $info;
    /**
     * Constructor method for chargeEvent
     * @uses ChargeEvent::setId()
     * @uses ChargeEvent::setPitch()
     * @uses ChargeEvent::setTime()
     * @uses ChargeEvent::setCode()
     * @uses ChargeEvent::setQuantity()
     * @uses ChargeEvent::setPrice()
     * @uses ChargeEvent::setDiscountPercent()
     * @uses ChargeEvent::setAmount()
     * @uses ChargeEvent::setInfo()
     * @param string $id
     * @param int $pitch
     * @param string $time
     * @param string $code
     * @param int $quantity
     * @param float $price
     * @param float $discountPercent
     * @param float $amount
     * @param string $info
     */
    public function __construct($id = null, $pitch = null, $time = null, $code = null, $quantity = null, $price = null, $discountPercent = null, $amount = null, $info = null)
    {
        $this
            ->setId($id)
            ->setPitch($pitch)
            ->setTime($time)
            ->setCode($code)
            ->setQuantity($quantity)
            ->setPrice($price)
            ->setDiscountPercent($discountPercent)
            ->setAmount($amount)
            ->setInfo($info);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ChargeEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Pitch value
     * @return int|null
     */
    public function getPitch()
    {
        return $this->Pitch;
    }
    /**
     * Set Pitch value
     * @param int $pitch
     * @return \StructType\ChargeEvent
     */
    public function setPitch($pitch = null)
    {
        // validation for constraint: int
        if (!is_null($pitch) && !(is_int($pitch) || ctype_digit($pitch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pitch, true), gettype($pitch)), __LINE__);
        }
        $this->Pitch = $pitch;
        return $this;
    }
    /**
     * Get time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\ChargeEvent
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\ChargeEvent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\ChargeEvent
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \StructType\ChargeEvent
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
    /**
     * Get discountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->discountPercent;
    }
    /**
     * Set discountPercent value
     * @param float $discountPercent
     * @return \StructType\ChargeEvent
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->discountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\ChargeEvent
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get info value
     * @return string|null
     */
    public function getInfo()
    {
        return $this->info;
    }
    /**
     * Set info value
     * @param string $info
     * @return \StructType\ChargeEvent
     */
    public function setInfo($info = null)
    {
        // validation for constraint: string
        if (!is_null($info) && !is_string($info)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($info, true), gettype($info)), __LINE__);
        }
        $this->info = $info;
        return $this;
    }
}
