<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getVersion operation/method
 */
if ($get->getVersion(new \StructType\GetVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Charge ServiceType
 */
$charge = new \ServiceType\Charge($options);
/**
 * Sample call for chargeEvent operation/method
 */
if ($charge->chargeEvent(new \StructType\ChargeEvent()) !== false) {
    print_r($charge->getResult());
} else {
    print_r($charge->getLastError());
}
/**
 * Samples for Call ServiceType
 */
$call = new \ServiceType\Call($options);
/**
 * Sample call for callChargeEvent operation/method
 */
if ($call->callChargeEvent(new \StructType\CallChargeEvent()) !== false) {
    print_r($call->getResult());
} else {
    print_r($call->getLastError());
}
/**
 * Samples for Pitch ServiceType
 */
$pitch = new \ServiceType\Pitch($options);
/**
 * Sample call for PitchStatusEvent operation/method
 */
if ($pitch->PitchStatusEvent(new \StructType\PitchStatusEvent()) !== false) {
    print_r($pitch->getResult());
} else {
    print_r($pitch->getLastError());
}
/**
 * Samples for Message ServiceType
 */
$message = new \ServiceType\Message($options);
/**
 * Sample call for messageEvent operation/method
 */
if ($message->messageEvent(new \StructType\MessageEvent()) !== false) {
    print_r($message->getResult());
} else {
    print_r($message->getLastError());
}
