<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for callChargeEvent StructType
 * @subpackage Structs
 */
class CallChargeEvent extends AbstractStructBase
{
    /**
     * The id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The Pitch
     * @var int
     */
    public $Pitch;
    /**
     * The callNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $callNumber;
    /**
     * The time
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $time;
    /**
     * The duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $duration;
    /**
     * The units
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $units;
    /**
     * The amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $amount;
    /**
     * Constructor method for callChargeEvent
     * @uses CallChargeEvent::setId()
     * @uses CallChargeEvent::setPitch()
     * @uses CallChargeEvent::setCallNumber()
     * @uses CallChargeEvent::setTime()
     * @uses CallChargeEvent::setDuration()
     * @uses CallChargeEvent::setUnits()
     * @uses CallChargeEvent::setAmount()
     * @param string $id
     * @param int $pitch
     * @param string $callNumber
     * @param string $time
     * @param int $duration
     * @param int $units
     * @param float $amount
     */
    public function __construct($id = null, $pitch = null, $callNumber = null, $time = null, $duration = null, $units = null, $amount = null)
    {
        $this
            ->setId($id)
            ->setPitch($pitch)
            ->setCallNumber($callNumber)
            ->setTime($time)
            ->setDuration($duration)
            ->setUnits($units)
            ->setAmount($amount);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\CallChargeEvent
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get Pitch value
     * @return int|null
     */
    public function getPitch()
    {
        return $this->Pitch;
    }
    /**
     * Set Pitch value
     * @param int $pitch
     * @return \StructType\CallChargeEvent
     */
    public function setPitch($pitch = null)
    {
        // validation for constraint: int
        if (!is_null($pitch) && !(is_int($pitch) || ctype_digit($pitch))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pitch, true), gettype($pitch)), __LINE__);
        }
        $this->Pitch = $pitch;
        return $this;
    }
    /**
     * Get callNumber value
     * @return string|null
     */
    public function getCallNumber()
    {
        return $this->callNumber;
    }
    /**
     * Set callNumber value
     * @param string $callNumber
     * @return \StructType\CallChargeEvent
     */
    public function setCallNumber($callNumber = null)
    {
        // validation for constraint: string
        if (!is_null($callNumber) && !is_string($callNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($callNumber, true), gettype($callNumber)), __LINE__);
        }
        $this->callNumber = $callNumber;
        return $this;
    }
    /**
     * Get time value
     * @return string|null
     */
    public function getTime()
    {
        return $this->time;
    }
    /**
     * Set time value
     * @param string $time
     * @return \StructType\CallChargeEvent
     */
    public function setTime($time = null)
    {
        // validation for constraint: string
        if (!is_null($time) && !is_string($time)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($time, true), gettype($time)), __LINE__);
        }
        $this->time = $time;
        return $this;
    }
    /**
     * Get duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->duration;
    }
    /**
     * Set duration value
     * @param int $duration
     * @return \StructType\CallChargeEvent
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->duration = $duration;
        return $this;
    }
    /**
     * Get units value
     * @return int|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param int $units
     * @return \StructType\CallChargeEvent
     */
    public function setUnits($units = null)
    {
        // validation for constraint: int
        if (!is_null($units) && !(is_int($units) || ctype_digit($units))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($units, true), gettype($units)), __LINE__);
        }
        $this->units = $units;
        return $this;
    }
    /**
     * Get amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param float $amount
     * @return \StructType\CallChargeEvent
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->amount = $amount;
        return $this;
    }
}
