<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pitch ServiceType
 * @subpackage Services
 */
class Pitch extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PitchStatusEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PitchStatusEvent $parameters
     * @return \StructType\PitchStatusEventResponse|bool
     */
    public function PitchStatusEvent(\StructType\PitchStatusEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PitchStatusEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PitchStatusEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
