<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Message ServiceType
 * @subpackage Services
 */
class Message extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named messageEvent
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MessageEvent $parameters
     * @return \StructType\MessageEventResponse|bool
     */
    public function messageEvent(\StructType\MessageEvent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->messageEvent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageEventResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
