<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for sendDataExtraccionSuperficial StructType
 * Meta information extracted from the WSDL
 * - documentation: Sección para envio datos extraccion de aguasSuperficial
 * @subpackage Structs
 */
class SendDataExtraccionSuperficial extends AbstractStructBase
{
    /**
     * The fechaMedicion
     * Meta information extracted from the WSDL
     * - documentation: Fecha de la medición (dd-mm-yyyy).
     * @var string
     */
    public $fechaMedicion;
    /**
     * The horaMedicion
     * Meta information extracted from the WSDL
     * - documentation: Hora de la medición (hh:mm:ss).Formato de 24 horas.
     * @var string
     */
    public $horaMedicion;
    /**
     * The caudal
     * Meta information extracted from the WSDL
     * - documentation: Caudal medido con el flujómetro enl/s. Con 2 decimales.
     * - base: xsd:decimal
     * @var float
     */
    public $caudal;
    /**
     * The alturaLimnimetrica
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * @var float
     */
    public $alturaLimnimetrica;
    /**
     * Constructor method for sendDataExtraccionSuperficial
     * @uses SendDataExtraccionSuperficial::setFechaMedicion()
     * @uses SendDataExtraccionSuperficial::setHoraMedicion()
     * @uses SendDataExtraccionSuperficial::setCaudal()
     * @uses SendDataExtraccionSuperficial::setAlturaLimnimetrica()
     * @param string $fechaMedicion
     * @param string $horaMedicion
     * @param float $caudal
     * @param float $alturaLimnimetrica
     */
    public function __construct($fechaMedicion = null, $horaMedicion = null, $caudal = null, $alturaLimnimetrica = null)
    {
        $this
            ->setFechaMedicion($fechaMedicion)
            ->setHoraMedicion($horaMedicion)
            ->setCaudal($caudal)
            ->setAlturaLimnimetrica($alturaLimnimetrica);
    }
    /**
     * Get fechaMedicion value
     * @return string|null
     */
    public function getFechaMedicion()
    {
        return $this->fechaMedicion;
    }
    /**
     * Set fechaMedicion value
     * @param string $fechaMedicion
     * @return \StructType\SendDataExtraccionSuperficial
     */
    public function setFechaMedicion($fechaMedicion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaMedicion) && !is_string($fechaMedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaMedicion, true), gettype($fechaMedicion)), __LINE__);
        }
        $this->fechaMedicion = $fechaMedicion;
        return $this;
    }
    /**
     * Get horaMedicion value
     * @return string|null
     */
    public function getHoraMedicion()
    {
        return $this->horaMedicion;
    }
    /**
     * Set horaMedicion value
     * @param string $horaMedicion
     * @return \StructType\SendDataExtraccionSuperficial
     */
    public function setHoraMedicion($horaMedicion = null)
    {
        // validation for constraint: string
        if (!is_null($horaMedicion) && !is_string($horaMedicion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($horaMedicion, true), gettype($horaMedicion)), __LINE__);
        }
        $this->horaMedicion = $horaMedicion;
        return $this;
    }
    /**
     * Get caudal value
     * @return float|null
     */
    public function getCaudal()
    {
        return $this->caudal;
    }
    /**
     * Set caudal value
     * @param float $caudal
     * @return \StructType\SendDataExtraccionSuperficial
     */
    public function setCaudal($caudal = null)
    {
        // validation for constraint: float
        if (!is_null($caudal) && !(is_float($caudal) || is_numeric($caudal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($caudal, true), gettype($caudal)), __LINE__);
        }
        $this->caudal = $caudal;
        return $this;
    }
    /**
     * Get alturaLimnimetrica value
     * @return float|null
     */
    public function getAlturaLimnimetrica()
    {
        return $this->alturaLimnimetrica;
    }
    /**
     * Set alturaLimnimetrica value
     * @param float $alturaLimnimetrica
     * @return \StructType\SendDataExtraccionSuperficial
     */
    public function setAlturaLimnimetrica($alturaLimnimetrica = null)
    {
        // validation for constraint: float
        if (!is_null($alturaLimnimetrica) && !(is_float($alturaLimnimetrica) || is_numeric($alturaLimnimetrica))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($alturaLimnimetrica, true), gettype($alturaLimnimetrica)), __LINE__);
        }
        $this->alturaLimnimetrica = $alturaLimnimetrica;
        return $this;
    }
}
