<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ifs.graphikservices.com/build_1_8_2/services/orderService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ifs.graphikservices.com/build_1_8_2/services/orderService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GraphikDimensions\ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \GraphikDimensions\ServiceType\Get($options);
/**
 * Sample call for getOrderStatus operation/method
 */
if ($get->getOrderStatus(new \GraphikDimensions\StructType\GetOrderStatus()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrderByCustomerName operation/method
 */
if ($get->getOrderByCustomerName(new \GraphikDimensions\StructType\GetOrderByCustomerName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getOrderStatusHistory operation/method
 */
if ($get->getOrderStatusHistory(new \GraphikDimensions\StructType\GetOrderStatusHistory()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Introduce ServiceType
 */
$introduce = new \GraphikDimensions\ServiceType\Introduce($options);
/**
 * Sample call for introduceExternalObjects operation/method
 */
if ($introduce->introduceExternalObjects(new \GraphikDimensions\StructType\IntroduceExternalObjects()) !== false) {
    print_r($introduce->getResult());
} else {
    print_r($introduce->getLastError());
}
/**
 * Samples for Process ServiceType
 */
$process = new \GraphikDimensions\ServiceType\Process($options);
/**
 * Sample call for processOrder operation/method
 */
if ($process->processOrder(new \GraphikDimensions\StructType\ProcessOrder()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for processCoupon operation/method
 */
if ($process->processCoupon(new \GraphikDimensions\StructType\ProcessCoupon()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for processFramerOrder operation/method
 */
if ($process->processFramerOrder(new \GraphikDimensions\StructType\ProcessFramerOrder()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Prepare ServiceType
 */
$prepare = new \GraphikDimensions\ServiceType\Prepare($options);
/**
 * Sample call for prepareOrder operation/method
 */
if ($prepare->prepareOrder(new \GraphikDimensions\StructType\PrepareOrder()) !== false) {
    print_r($prepare->getResult());
} else {
    print_r($prepare->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \GraphikDimensions\ServiceType\Add($options);
/**
 * Sample call for addProductToPackage operation/method
 */
if ($add->addProductToPackage(new \GraphikDimensions\StructType\AddProductToPackage()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Set ServiceType
 */
$set = new \GraphikDimensions\ServiceType\Set($options);
/**
 * Sample call for setOrderStatus operation/method
 */
if ($set->setOrderStatus(new \GraphikDimensions\StructType\SetOrderStatus()) !== false) {
    print_r($set->getResult());
} else {
    print_r($set->getLastError());
}
/**
 * Samples for Validate ServiceType
 */
$validate = new \GraphikDimensions\ServiceType\Validate($options);
/**
 * Sample call for validatePaymentMethods operation/method
 */
if ($validate->validatePaymentMethods(new \GraphikDimensions\StructType\ValidatePaymentMethods()) !== false) {
    print_r($validate->getResult());
} else {
    print_r($validate->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \GraphikDimensions\ServiceType\Create($options);
/**
 * Sample call for createPackage operation/method
 */
if ($create->createPackage(new \GraphikDimensions\StructType\CreatePackage()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createPrePackage operation/method
 */
if ($create->createPrePackage(new \GraphikDimensions\StructType\CreatePrePackage()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \GraphikDimensions\ServiceType\Remove($options);
/**
 * Sample call for removeProductFromPackage operation/method
 */
if ($remove->removeProductFromPackage(new \GraphikDimensions\StructType\RemoveProductFromPackage()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
