<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for substrate StructType
 * @subpackage Structs
 * @Generated by providr
 */
class Substrate extends DimensionedExternalProduct
{
    /**
     * The classification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $classification;
    /**
     * The inkType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $inkType;
    /**
     * The intercept
     * @var float
     */
    public $intercept;
    /**
     * The longevity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $longevity;
    /**
     * The materialType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $materialType;
    /**
     * The mountType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mountType;
    /**
     * The resolutionQuality
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resolutionQuality;
    /**
     * The slope
     * @var float
     */
    public $slope;
    /**
     * The thickness
     * @var float
     */
    public $thickness;
    /**
     * The weight
     * @var float
     */
    public $weight;
    /**
     * The wrapWidth
     * @var float
     */
    public $wrapWidth;
    /**
     * Constructor method for substrate
     * @uses Substrate::setClassification()
     * @uses Substrate::setInkType()
     * @uses Substrate::setIntercept()
     * @uses Substrate::setLongevity()
     * @uses Substrate::setMaterialType()
     * @uses Substrate::setMountType()
     * @uses Substrate::setResolutionQuality()
     * @uses Substrate::setSlope()
     * @uses Substrate::setThickness()
     * @uses Substrate::setWeight()
     * @uses Substrate::setWrapWidth()
     * @param string $classification
     * @param string $inkType
     * @param float $intercept
     * @param string $longevity
     * @param string $materialType
     * @param string $mountType
     * @param string $resolutionQuality
     * @param float $slope
     * @param float $thickness
     * @param float $weight
     * @param float $wrapWidth
     */
    public function __construct($classification = null, $inkType = null, $intercept = null, $longevity = null, $materialType = null, $mountType = null, $resolutionQuality = null, $slope = null, $thickness = null, $weight = null, $wrapWidth = null)
    {
        $this
            ->setClassification($classification)
            ->setInkType($inkType)
            ->setIntercept($intercept)
            ->setLongevity($longevity)
            ->setMaterialType($materialType)
            ->setMountType($mountType)
            ->setResolutionQuality($resolutionQuality)
            ->setSlope($slope)
            ->setThickness($thickness)
            ->setWeight($weight)
            ->setWrapWidth($wrapWidth);
    }
    /**
     * Get classification value
     * @return string|null
     */
    public function getClassification()
    {
        return $this->classification;
    }
    /**
     * Set classification value
     * @param string $classification
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setClassification($classification = null)
    {
        // validation for constraint: string
        if (!is_null($classification) && !is_string($classification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($classification)), __LINE__);
        }
        $this->classification = $classification;
        return $this;
    }
    /**
     * Get inkType value
     * @return string|null
     */
    public function getInkType()
    {
        return $this->inkType;
    }
    /**
     * Set inkType value
     * @param string $inkType
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setInkType($inkType = null)
    {
        // validation for constraint: string
        if (!is_null($inkType) && !is_string($inkType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($inkType)), __LINE__);
        }
        $this->inkType = $inkType;
        return $this;
    }
    /**
     * Get intercept value
     * @return float|null
     */
    public function getIntercept()
    {
        return $this->intercept;
    }
    /**
     * Set intercept value
     * @param float $intercept
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setIntercept($intercept = null)
    {
        $this->intercept = $intercept;
        return $this;
    }
    /**
     * Get longevity value
     * @return string|null
     */
    public function getLongevity()
    {
        return $this->longevity;
    }
    /**
     * Set longevity value
     * @param string $longevity
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setLongevity($longevity = null)
    {
        // validation for constraint: string
        if (!is_null($longevity) && !is_string($longevity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($longevity)), __LINE__);
        }
        $this->longevity = $longevity;
        return $this;
    }
    /**
     * Get materialType value
     * @return string|null
     */
    public function getMaterialType()
    {
        return $this->materialType;
    }
    /**
     * Set materialType value
     * @param string $materialType
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setMaterialType($materialType = null)
    {
        // validation for constraint: string
        if (!is_null($materialType) && !is_string($materialType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($materialType)), __LINE__);
        }
        $this->materialType = $materialType;
        return $this;
    }
    /**
     * Get mountType value
     * @return string|null
     */
    public function getMountType()
    {
        return $this->mountType;
    }
    /**
     * Set mountType value
     * @uses \GraphikDimensions\EnumType\MountTypes::valueIsValid()
     * @uses \GraphikDimensions\EnumType\MountTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $mountType
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setMountType($mountType = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\MountTypes::valueIsValid($mountType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $mountType, implode(', ', \GraphikDimensions\EnumType\MountTypes::getValidValues())), __LINE__);
        }
        $this->mountType = $mountType;
        return $this;
    }
    /**
     * Get resolutionQuality value
     * @return string|null
     */
    public function getResolutionQuality()
    {
        return $this->resolutionQuality;
    }
    /**
     * Set resolutionQuality value
     * @param string $resolutionQuality
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setResolutionQuality($resolutionQuality = null)
    {
        // validation for constraint: string
        if (!is_null($resolutionQuality) && !is_string($resolutionQuality)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($resolutionQuality)), __LINE__);
        }
        $this->resolutionQuality = $resolutionQuality;
        return $this;
    }
    /**
     * Get slope value
     * @return float|null
     */
    public function getSlope()
    {
        return $this->slope;
    }
    /**
     * Set slope value
     * @param float $slope
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setSlope($slope = null)
    {
        $this->slope = $slope;
        return $this;
    }
    /**
     * Get thickness value
     * @return float|null
     */
    public function getThickness()
    {
        return $this->thickness;
    }
    /**
     * Set thickness value
     * @param float $thickness
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setThickness($thickness = null)
    {
        $this->thickness = $thickness;
        return $this;
    }
    /**
     * Get weight value
     * @return float|null
     */
    public function getWeight()
    {
        return $this->weight;
    }
    /**
     * Set weight value
     * @param float $weight
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setWeight($weight = null)
    {
        $this->weight = $weight;
        return $this;
    }
    /**
     * Get wrapWidth value
     * @return float|null
     */
    public function getWrapWidth()
    {
        return $this->wrapWidth;
    }
    /**
     * Set wrapWidth value
     * @param float $wrapWidth
     * @return \GraphikDimensions\StructType\Substrate
     */
    public function setWrapWidth($wrapWidth = null)
    {
        $this->wrapWidth = $wrapWidth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\Substrate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
