<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for paymentMethod StructType
 * @subpackage Structs
 * @Generated by providr
 */
abstract class PaymentMethod extends AbstractStructBase
{
    /**
     * The messages
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $messages;
    /**
     * The isValid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isValid;
    /**
     * Constructor method for paymentMethod
     * @uses PaymentMethod::setMessages()
     * @uses PaymentMethod::setIsValid()
     * @param string[] $messages
     * @param bool $isValid
     */
    public function __construct(array $messages = array(), $isValid = null)
    {
        $this
            ->setMessages($messages)
            ->setIsValid($isValid);
    }
    /**
     * Get messages value
     * @return string[]|null
     */
    public function getMessages()
    {
        return $this->messages;
    }
    /**
     * Set messages value
     * @throws \InvalidArgumentException
     * @param string[] $messages
     * @return \GraphikDimensions\StructType\PaymentMethod
     */
    public function setMessages(array $messages = array())
    {
        foreach ($messages as $paymentMethodMessagesItem) {
            // validation for constraint: itemType
            if (!is_string($paymentMethodMessagesItem)) {
                throw new \InvalidArgumentException(sprintf('The messages property can only contain items of string, "%s" given', is_object($paymentMethodMessagesItem) ? get_class($paymentMethodMessagesItem) : gettype($paymentMethodMessagesItem)), __LINE__);
            }
        }
        $this->messages = $messages;
        return $this;
    }
    /**
     * Add item to messages value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GraphikDimensions\StructType\PaymentMethod
     */
    public function addToMessages($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The messages property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->messages[] = $item;
        return $this;
    }
    /**
     * Get isValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->isValid) ? $this->isValid : null;
    }
    /**
     * Set isValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \GraphikDimensions\StructType\PaymentMethod
     */
    public function setIsValid($isValid = null)
    {
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->isValid);
        } else {
            $this->isValid = $isValid;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\PaymentMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
