<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for mat StructType
 * @subpackage Structs
 * @Generated by providr
 */
class Mat extends DimensionedExternalProduct
{
    /**
     * The bottomBorder
     * @var float
     */
    public $bottomBorder;
    /**
     * The color
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $color;
    /**
     * The coreColor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $coreColor;
    /**
     * The fillet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\Fillet
     */
    public $fillet;
    /**
     * The filleted
     * @var bool
     */
    public $filleted;
    /**
     * The leftBorder
     * @var float
     */
    public $leftBorder;
    /**
     * The maxLongestSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxLongestSize;
    /**
     * The maxShortestSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $maxShortestSize;
    /**
     * The maxUnCutPurchaseSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\Dimension
     */
    public $maxUnCutPurchaseSize;
    /**
     * The minUnCutPurchaseSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\Dimension
     */
    public $minUnCutPurchaseSize;
    /**
     * The numberOfCuts
     * @var int
     */
    public $numberOfCuts;
    /**
     * The offset
     * @var float
     */
    public $offset;
    /**
     * The overSizedMatSku
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $overSizedMatSku;
    /**
     * The raised
     * @var bool
     */
    public $raised;
    /**
     * The reverseBevelCut
     * @var bool
     */
    public $reverseBevelCut;
    /**
     * The rightBorder
     * @var float
     */
    public $rightBorder;
    /**
     * The shape
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $shape;
    /**
     * The sizeMatToImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $sizeMatToImage;
    /**
     * The standardCut
     * @var bool
     */
    public $standardCut;
    /**
     * The straightCut
     * @var bool
     */
    public $straightCut;
    /**
     * The topBorder
     * @var float
     */
    public $topBorder;
    /**
     * The types
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $types;
    /**
     * The VGroove
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\VGroove
     */
    public $VGroove;
    /**
     * The VGrooveOffset
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VGrooveOffset;
    /**
     * The VGrooveWidth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $VGrooveWidth;
    /**
     * The VGrooved
     * @var bool
     */
    public $VGrooved;
    /**
     * The windowHeight
     * @var float
     */
    public $windowHeight;
    /**
     * The windowWidth
     * @var float
     */
    public $windowWidth;
    /**
     * Constructor method for mat
     * @uses Mat::setBottomBorder()
     * @uses Mat::setColor()
     * @uses Mat::setCoreColor()
     * @uses Mat::setFillet()
     * @uses Mat::setFilleted()
     * @uses Mat::setLeftBorder()
     * @uses Mat::setMaxLongestSize()
     * @uses Mat::setMaxShortestSize()
     * @uses Mat::setMaxUnCutPurchaseSize()
     * @uses Mat::setMinUnCutPurchaseSize()
     * @uses Mat::setNumberOfCuts()
     * @uses Mat::setOffset()
     * @uses Mat::setOverSizedMatSku()
     * @uses Mat::setRaised()
     * @uses Mat::setReverseBevelCut()
     * @uses Mat::setRightBorder()
     * @uses Mat::setShape()
     * @uses Mat::setSizeMatToImage()
     * @uses Mat::setStandardCut()
     * @uses Mat::setStraightCut()
     * @uses Mat::setTopBorder()
     * @uses Mat::setTypes()
     * @uses Mat::setVGroove()
     * @uses Mat::setVGrooveOffset()
     * @uses Mat::setVGrooveWidth()
     * @uses Mat::setVGrooved()
     * @uses Mat::setWindowHeight()
     * @uses Mat::setWindowWidth()
     * @param float $bottomBorder
     * @param string $color
     * @param string $coreColor
     * @param \GraphikDimensions\StructType\Fillet $fillet
     * @param bool $filleted
     * @param float $leftBorder
     * @param float $maxLongestSize
     * @param float $maxShortestSize
     * @param \GraphikDimensions\StructType\Dimension $maxUnCutPurchaseSize
     * @param \GraphikDimensions\StructType\Dimension $minUnCutPurchaseSize
     * @param int $numberOfCuts
     * @param float $offset
     * @param string $overSizedMatSku
     * @param bool $raised
     * @param bool $reverseBevelCut
     * @param float $rightBorder
     * @param string $shape
     * @param int $sizeMatToImage
     * @param bool $standardCut
     * @param bool $straightCut
     * @param float $topBorder
     * @param string[] $types
     * @param \GraphikDimensions\StructType\VGroove $vGroove
     * @param float $vGrooveOffset
     * @param float $vGrooveWidth
     * @param bool $vGrooved
     * @param float $windowHeight
     * @param float $windowWidth
     */
    public function __construct($bottomBorder = null, $color = null, $coreColor = null, \GraphikDimensions\StructType\Fillet $fillet = null, $filleted = null, $leftBorder = null, $maxLongestSize = null, $maxShortestSize = null, \GraphikDimensions\StructType\Dimension $maxUnCutPurchaseSize = null, \GraphikDimensions\StructType\Dimension $minUnCutPurchaseSize = null, $numberOfCuts = null, $offset = null, $overSizedMatSku = null, $raised = null, $reverseBevelCut = null, $rightBorder = null, $shape = null, $sizeMatToImage = null, $standardCut = null, $straightCut = null, $topBorder = null, array $types = array(), \GraphikDimensions\StructType\VGroove $vGroove = null, $vGrooveOffset = null, $vGrooveWidth = null, $vGrooved = null, $windowHeight = null, $windowWidth = null)
    {
        $this
            ->setBottomBorder($bottomBorder)
            ->setColor($color)
            ->setCoreColor($coreColor)
            ->setFillet($fillet)
            ->setFilleted($filleted)
            ->setLeftBorder($leftBorder)
            ->setMaxLongestSize($maxLongestSize)
            ->setMaxShortestSize($maxShortestSize)
            ->setMaxUnCutPurchaseSize($maxUnCutPurchaseSize)
            ->setMinUnCutPurchaseSize($minUnCutPurchaseSize)
            ->setNumberOfCuts($numberOfCuts)
            ->setOffset($offset)
            ->setOverSizedMatSku($overSizedMatSku)
            ->setRaised($raised)
            ->setReverseBevelCut($reverseBevelCut)
            ->setRightBorder($rightBorder)
            ->setShape($shape)
            ->setSizeMatToImage($sizeMatToImage)
            ->setStandardCut($standardCut)
            ->setStraightCut($straightCut)
            ->setTopBorder($topBorder)
            ->setTypes($types)
            ->setVGroove($vGroove)
            ->setVGrooveOffset($vGrooveOffset)
            ->setVGrooveWidth($vGrooveWidth)
            ->setVGrooved($vGrooved)
            ->setWindowHeight($windowHeight)
            ->setWindowWidth($windowWidth);
    }
    /**
     * Get bottomBorder value
     * @return float|null
     */
    public function getBottomBorder()
    {
        return $this->bottomBorder;
    }
    /**
     * Set bottomBorder value
     * @param float $bottomBorder
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setBottomBorder($bottomBorder = null)
    {
        $this->bottomBorder = $bottomBorder;
        return $this;
    }
    /**
     * Get color value
     * @return string|null
     */
    public function getColor()
    {
        return $this->color;
    }
    /**
     * Set color value
     * @param string $color
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setColor($color = null)
    {
        // validation for constraint: string
        if (!is_null($color) && !is_string($color)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($color)), __LINE__);
        }
        $this->color = $color;
        return $this;
    }
    /**
     * Get coreColor value
     * @return string|null
     */
    public function getCoreColor()
    {
        return $this->coreColor;
    }
    /**
     * Set coreColor value
     * @param string $coreColor
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setCoreColor($coreColor = null)
    {
        // validation for constraint: string
        if (!is_null($coreColor) && !is_string($coreColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($coreColor)), __LINE__);
        }
        $this->coreColor = $coreColor;
        return $this;
    }
    /**
     * Get fillet value
     * @return \GraphikDimensions\StructType\Fillet|null
     */
    public function getFillet()
    {
        return $this->fillet;
    }
    /**
     * Set fillet value
     * @param \GraphikDimensions\StructType\Fillet $fillet
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setFillet(\GraphikDimensions\StructType\Fillet $fillet = null)
    {
        $this->fillet = $fillet;
        return $this;
    }
    /**
     * Get filleted value
     * @return bool|null
     */
    public function getFilleted()
    {
        return $this->filleted;
    }
    /**
     * Set filleted value
     * @param bool $filleted
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setFilleted($filleted = null)
    {
        $this->filleted = $filleted;
        return $this;
    }
    /**
     * Get leftBorder value
     * @return float|null
     */
    public function getLeftBorder()
    {
        return $this->leftBorder;
    }
    /**
     * Set leftBorder value
     * @param float $leftBorder
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setLeftBorder($leftBorder = null)
    {
        $this->leftBorder = $leftBorder;
        return $this;
    }
    /**
     * Get maxLongestSize value
     * @return float|null
     */
    public function getMaxLongestSize()
    {
        return $this->maxLongestSize;
    }
    /**
     * Set maxLongestSize value
     * @param float $maxLongestSize
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setMaxLongestSize($maxLongestSize = null)
    {
        $this->maxLongestSize = $maxLongestSize;
        return $this;
    }
    /**
     * Get maxShortestSize value
     * @return float|null
     */
    public function getMaxShortestSize()
    {
        return $this->maxShortestSize;
    }
    /**
     * Set maxShortestSize value
     * @param float $maxShortestSize
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setMaxShortestSize($maxShortestSize = null)
    {
        $this->maxShortestSize = $maxShortestSize;
        return $this;
    }
    /**
     * Get maxUnCutPurchaseSize value
     * @return \GraphikDimensions\StructType\Dimension|null
     */
    public function getMaxUnCutPurchaseSize()
    {
        return $this->maxUnCutPurchaseSize;
    }
    /**
     * Set maxUnCutPurchaseSize value
     * @param \GraphikDimensions\StructType\Dimension $maxUnCutPurchaseSize
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setMaxUnCutPurchaseSize(\GraphikDimensions\StructType\Dimension $maxUnCutPurchaseSize = null)
    {
        $this->maxUnCutPurchaseSize = $maxUnCutPurchaseSize;
        return $this;
    }
    /**
     * Get minUnCutPurchaseSize value
     * @return \GraphikDimensions\StructType\Dimension|null
     */
    public function getMinUnCutPurchaseSize()
    {
        return $this->minUnCutPurchaseSize;
    }
    /**
     * Set minUnCutPurchaseSize value
     * @param \GraphikDimensions\StructType\Dimension $minUnCutPurchaseSize
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setMinUnCutPurchaseSize(\GraphikDimensions\StructType\Dimension $minUnCutPurchaseSize = null)
    {
        $this->minUnCutPurchaseSize = $minUnCutPurchaseSize;
        return $this;
    }
    /**
     * Get numberOfCuts value
     * @return int|null
     */
    public function getNumberOfCuts()
    {
        return $this->numberOfCuts;
    }
    /**
     * Set numberOfCuts value
     * @param int $numberOfCuts
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setNumberOfCuts($numberOfCuts = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCuts) && !is_numeric($numberOfCuts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numberOfCuts)), __LINE__);
        }
        $this->numberOfCuts = $numberOfCuts;
        return $this;
    }
    /**
     * Get offset value
     * @return float|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param float $offset
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setOffset($offset = null)
    {
        $this->offset = $offset;
        return $this;
    }
    /**
     * Get overSizedMatSku value
     * @return string|null
     */
    public function getOverSizedMatSku()
    {
        return $this->overSizedMatSku;
    }
    /**
     * Set overSizedMatSku value
     * @param string $overSizedMatSku
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setOverSizedMatSku($overSizedMatSku = null)
    {
        // validation for constraint: string
        if (!is_null($overSizedMatSku) && !is_string($overSizedMatSku)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($overSizedMatSku)), __LINE__);
        }
        $this->overSizedMatSku = $overSizedMatSku;
        return $this;
    }
    /**
     * Get raised value
     * @return bool|null
     */
    public function getRaised()
    {
        return $this->raised;
    }
    /**
     * Set raised value
     * @param bool $raised
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setRaised($raised = null)
    {
        $this->raised = $raised;
        return $this;
    }
    /**
     * Get reverseBevelCut value
     * @return bool|null
     */
    public function getReverseBevelCut()
    {
        return $this->reverseBevelCut;
    }
    /**
     * Set reverseBevelCut value
     * @param bool $reverseBevelCut
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setReverseBevelCut($reverseBevelCut = null)
    {
        $this->reverseBevelCut = $reverseBevelCut;
        return $this;
    }
    /**
     * Get rightBorder value
     * @return float|null
     */
    public function getRightBorder()
    {
        return $this->rightBorder;
    }
    /**
     * Set rightBorder value
     * @param float $rightBorder
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setRightBorder($rightBorder = null)
    {
        $this->rightBorder = $rightBorder;
        return $this;
    }
    /**
     * Get shape value
     * @return string|null
     */
    public function getShape()
    {
        return $this->shape;
    }
    /**
     * Set shape value
     * @uses \GraphikDimensions\EnumType\Shape::valueIsValid()
     * @uses \GraphikDimensions\EnumType\Shape::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shape
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setShape($shape = null)
    {
        // validation for constraint: enumeration
        if (!\GraphikDimensions\EnumType\Shape::valueIsValid($shape)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shape, implode(', ', \GraphikDimensions\EnumType\Shape::getValidValues())), __LINE__);
        }
        $this->shape = $shape;
        return $this;
    }
    /**
     * Get sizeMatToImage value
     * @return int|null
     */
    public function getSizeMatToImage()
    {
        return $this->sizeMatToImage;
    }
    /**
     * Set sizeMatToImage value
     * @param int $sizeMatToImage
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setSizeMatToImage($sizeMatToImage = null)
    {
        // validation for constraint: int
        if (!is_null($sizeMatToImage) && !is_numeric($sizeMatToImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sizeMatToImage)), __LINE__);
        }
        $this->sizeMatToImage = $sizeMatToImage;
        return $this;
    }
    /**
     * Get standardCut value
     * @return bool|null
     */
    public function getStandardCut()
    {
        return $this->standardCut;
    }
    /**
     * Set standardCut value
     * @param bool $standardCut
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setStandardCut($standardCut = null)
    {
        $this->standardCut = $standardCut;
        return $this;
    }
    /**
     * Get straightCut value
     * @return bool|null
     */
    public function getStraightCut()
    {
        return $this->straightCut;
    }
    /**
     * Set straightCut value
     * @param bool $straightCut
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setStraightCut($straightCut = null)
    {
        $this->straightCut = $straightCut;
        return $this;
    }
    /**
     * Get topBorder value
     * @return float|null
     */
    public function getTopBorder()
    {
        return $this->topBorder;
    }
    /**
     * Set topBorder value
     * @param float $topBorder
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setTopBorder($topBorder = null)
    {
        $this->topBorder = $topBorder;
        return $this;
    }
    /**
     * Get types value
     * @return string[]|null
     */
    public function getTypes()
    {
        return $this->types;
    }
    /**
     * Set types value
     * @throws \InvalidArgumentException
     * @param string[] $types
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setTypes(array $types = array())
    {
        foreach ($types as $matTypesItem) {
            // validation for constraint: itemType
            if (!is_string($matTypesItem)) {
                throw new \InvalidArgumentException(sprintf('The types property can only contain items of string, "%s" given', is_object($matTypesItem) ? get_class($matTypesItem) : gettype($matTypesItem)), __LINE__);
            }
        }
        $this->types = $types;
        return $this;
    }
    /**
     * Add item to types value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \GraphikDimensions\StructType\Mat
     */
    public function addToTypes($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The types property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->types[] = $item;
        return $this;
    }
    /**
     * Get VGroove value
     * @return \GraphikDimensions\StructType\VGroove|null
     */
    public function getVGroove()
    {
        return $this->VGroove;
    }
    /**
     * Set VGroove value
     * @param \GraphikDimensions\StructType\VGroove $vGroove
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setVGroove(\GraphikDimensions\StructType\VGroove $vGroove = null)
    {
        $this->VGroove = $vGroove;
        return $this;
    }
    /**
     * Get VGrooveOffset value
     * @return float|null
     */
    public function getVGrooveOffset()
    {
        return $this->VGrooveOffset;
    }
    /**
     * Set VGrooveOffset value
     * @param float $vGrooveOffset
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setVGrooveOffset($vGrooveOffset = null)
    {
        $this->VGrooveOffset = $vGrooveOffset;
        return $this;
    }
    /**
     * Get VGrooveWidth value
     * @return float|null
     */
    public function getVGrooveWidth()
    {
        return $this->VGrooveWidth;
    }
    /**
     * Set VGrooveWidth value
     * @param float $vGrooveWidth
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setVGrooveWidth($vGrooveWidth = null)
    {
        $this->VGrooveWidth = $vGrooveWidth;
        return $this;
    }
    /**
     * Get VGrooved value
     * @return bool|null
     */
    public function getVGrooved()
    {
        return $this->VGrooved;
    }
    /**
     * Set VGrooved value
     * @param bool $vGrooved
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setVGrooved($vGrooved = null)
    {
        $this->VGrooved = $vGrooved;
        return $this;
    }
    /**
     * Get windowHeight value
     * @return float|null
     */
    public function getWindowHeight()
    {
        return $this->windowHeight;
    }
    /**
     * Set windowHeight value
     * @param float $windowHeight
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setWindowHeight($windowHeight = null)
    {
        $this->windowHeight = $windowHeight;
        return $this;
    }
    /**
     * Get windowWidth value
     * @return float|null
     */
    public function getWindowWidth()
    {
        return $this->windowWidth;
    }
    /**
     * Set windowWidth value
     * @param float $windowWidth
     * @return \GraphikDimensions\StructType\Mat
     */
    public function setWindowWidth($windowWidth = null)
    {
        $this->windowWidth = $windowWidth;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\Mat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
