<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for externalProductType StructType
 * @subpackage Structs
 * @Generated by providr
 */
class ExternalProductType extends AbstractStructBase
{
    /**
     * The codeText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codeText;
    /**
     * The descText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descText;
    /**
     * The productTypeDefs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \GraphikDimensions\StructType\ExternalProductTypeDef[]
     */
    public $productTypeDefs;
    /**
     * Constructor method for externalProductType
     * @uses ExternalProductType::setCodeText()
     * @uses ExternalProductType::setDescText()
     * @uses ExternalProductType::setProductTypeDefs()
     * @param string $codeText
     * @param string $descText
     * @param \GraphikDimensions\StructType\ExternalProductTypeDef[] $productTypeDefs
     */
    public function __construct($codeText = null, $descText = null, array $productTypeDefs = array())
    {
        $this
            ->setCodeText($codeText)
            ->setDescText($descText)
            ->setProductTypeDefs($productTypeDefs);
    }
    /**
     * Get codeText value
     * @return string|null
     */
    public function getCodeText()
    {
        return $this->codeText;
    }
    /**
     * Set codeText value
     * @param string $codeText
     * @return \GraphikDimensions\StructType\ExternalProductType
     */
    public function setCodeText($codeText = null)
    {
        // validation for constraint: string
        if (!is_null($codeText) && !is_string($codeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeText)), __LINE__);
        }
        $this->codeText = $codeText;
        return $this;
    }
    /**
     * Get descText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->descText;
    }
    /**
     * Set descText value
     * @param string $descText
     * @return \GraphikDimensions\StructType\ExternalProductType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descText)), __LINE__);
        }
        $this->descText = $descText;
        return $this;
    }
    /**
     * Get productTypeDefs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \GraphikDimensions\StructType\ExternalProductTypeDef[]|null
     */
    public function getProductTypeDefs()
    {
        return isset($this->productTypeDefs) ? $this->productTypeDefs : null;
    }
    /**
     * Set productTypeDefs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductTypeDef[] $productTypeDefs
     * @return \GraphikDimensions\StructType\ExternalProductType
     */
    public function setProductTypeDefs(array $productTypeDefs = array())
    {
        foreach ($productTypeDefs as $externalProductTypeProductTypeDefsItem) {
            // validation for constraint: itemType
            if (!$externalProductTypeProductTypeDefsItem instanceof \GraphikDimensions\StructType\ExternalProductTypeDef) {
                throw new \InvalidArgumentException(sprintf('The productTypeDefs property can only contain items of \GraphikDimensions\StructType\ExternalProductTypeDef, "%s" given', is_object($externalProductTypeProductTypeDefsItem) ? get_class($externalProductTypeProductTypeDefsItem) : gettype($externalProductTypeProductTypeDefsItem)), __LINE__);
            }
        }
        if (is_null($productTypeDefs) || (is_array($productTypeDefs) && empty($productTypeDefs))) {
            unset($this->productTypeDefs);
        } else {
            $this->productTypeDefs = $productTypeDefs;
        }
        return $this;
    }
    /**
     * Add item to productTypeDefs value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductTypeDef $item
     * @return \GraphikDimensions\StructType\ExternalProductType
     */
    public function addToProductTypeDefs(\GraphikDimensions\StructType\ExternalProductTypeDef $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProductTypeDef) {
            throw new \InvalidArgumentException(sprintf('The productTypeDefs property can only contain items of \GraphikDimensions\StructType\ExternalProductTypeDef, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productTypeDefs[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\ExternalProductType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
