<?php

namespace GraphikDimensions\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for frame StructType
 * @subpackage Structs
 * @Generated by providr
 */
class Frame extends DimensionedExternalProduct
{
    /**
     * The availableInCustomSizes
     * @var bool
     */
    public $availableInCustomSizes;
    /**
     * The classifications
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProductAttribute[]
     */
    public $classifications;
    /**
     * The colors
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProductAttribute[]
     */
    public $colors;
    /**
     * The cornerImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cornerImage;
    /**
     * The loadType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $loadType;
    /**
     * The material
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $material;
    /**
     * The maxAssembledSize
     * @var float
     */
    public $maxAssembledSize;
    /**
     * The mouldingImageSlice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mouldingImageSlice;
    /**
     * The mouldingThickness
     * @var float
     */
    public $mouldingThickness;
    /**
     * The mouldingWidth
     * @var float
     */
    public $mouldingWidth;
    /**
     * The oversizedFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\OversizedFee
     */
    public $oversizedFee;
    /**
     * The profileImage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $profileImage;
    /**
     * The rabbetDepth
     * @var float
     */
    public $rabbetDepth;
    /**
     * The rabbetWidth
     * @var float
     */
    public $rabbetWidth;
    /**
     * The readyMadeEquivalent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $readyMadeEquivalent;
    /**
     * The storeAssemble
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $storeAssemble;
    /**
     * The styles
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \GraphikDimensions\StructType\ExternalProductAttribute[]
     */
    public $styles;
    /**
     * Constructor method for frame
     * @uses Frame::setAvailableInCustomSizes()
     * @uses Frame::setClassifications()
     * @uses Frame::setColors()
     * @uses Frame::setCornerImage()
     * @uses Frame::setLoadType()
     * @uses Frame::setMaterial()
     * @uses Frame::setMaxAssembledSize()
     * @uses Frame::setMouldingImageSlice()
     * @uses Frame::setMouldingThickness()
     * @uses Frame::setMouldingWidth()
     * @uses Frame::setOversizedFee()
     * @uses Frame::setProfileImage()
     * @uses Frame::setRabbetDepth()
     * @uses Frame::setRabbetWidth()
     * @uses Frame::setReadyMadeEquivalent()
     * @uses Frame::setStoreAssemble()
     * @uses Frame::setStyles()
     * @param bool $availableInCustomSizes
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $classifications
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $colors
     * @param string $cornerImage
     * @param string $loadType
     * @param string $material
     * @param float $maxAssembledSize
     * @param string $mouldingImageSlice
     * @param float $mouldingThickness
     * @param float $mouldingWidth
     * @param \GraphikDimensions\StructType\OversizedFee $oversizedFee
     * @param string $profileImage
     * @param float $rabbetDepth
     * @param float $rabbetWidth
     * @param string $readyMadeEquivalent
     * @param bool $storeAssemble
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $styles
     */
    public function __construct($availableInCustomSizes = null, array $classifications = array(), array $colors = array(), $cornerImage = null, $loadType = null, $material = null, $maxAssembledSize = null, $mouldingImageSlice = null, $mouldingThickness = null, $mouldingWidth = null, \GraphikDimensions\StructType\OversizedFee $oversizedFee = null, $profileImage = null, $rabbetDepth = null, $rabbetWidth = null, $readyMadeEquivalent = null, $storeAssemble = null, array $styles = array())
    {
        $this
            ->setAvailableInCustomSizes($availableInCustomSizes)
            ->setClassifications($classifications)
            ->setColors($colors)
            ->setCornerImage($cornerImage)
            ->setLoadType($loadType)
            ->setMaterial($material)
            ->setMaxAssembledSize($maxAssembledSize)
            ->setMouldingImageSlice($mouldingImageSlice)
            ->setMouldingThickness($mouldingThickness)
            ->setMouldingWidth($mouldingWidth)
            ->setOversizedFee($oversizedFee)
            ->setProfileImage($profileImage)
            ->setRabbetDepth($rabbetDepth)
            ->setRabbetWidth($rabbetWidth)
            ->setReadyMadeEquivalent($readyMadeEquivalent)
            ->setStoreAssemble($storeAssemble)
            ->setStyles($styles);
    }
    /**
     * Get availableInCustomSizes value
     * @return bool|null
     */
    public function getAvailableInCustomSizes()
    {
        return $this->availableInCustomSizes;
    }
    /**
     * Set availableInCustomSizes value
     * @param bool $availableInCustomSizes
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setAvailableInCustomSizes($availableInCustomSizes = null)
    {
        $this->availableInCustomSizes = $availableInCustomSizes;
        return $this;
    }
    /**
     * Get classifications value
     * @return \GraphikDimensions\StructType\ExternalProductAttribute[]|null
     */
    public function getClassifications()
    {
        return $this->classifications;
    }
    /**
     * Set classifications value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $classifications
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setClassifications(array $classifications = array())
    {
        foreach ($classifications as $frameClassificationsItem) {
            // validation for constraint: itemType
            if (!$frameClassificationsItem instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The classifications property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($frameClassificationsItem) ? get_class($frameClassificationsItem) : gettype($frameClassificationsItem)), __LINE__);
            }
        }
        $this->classifications = $classifications;
        return $this;
    }
    /**
     * Add item to classifications value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute $item
     * @return \GraphikDimensions\StructType\Frame
     */
    public function addToClassifications(\GraphikDimensions\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The classifications property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->classifications[] = $item;
        return $this;
    }
    /**
     * Get colors value
     * @return \GraphikDimensions\StructType\ExternalProductAttribute[]|null
     */
    public function getColors()
    {
        return $this->colors;
    }
    /**
     * Set colors value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $colors
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setColors(array $colors = array())
    {
        foreach ($colors as $frameColorsItem) {
            // validation for constraint: itemType
            if (!$frameColorsItem instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The colors property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($frameColorsItem) ? get_class($frameColorsItem) : gettype($frameColorsItem)), __LINE__);
            }
        }
        $this->colors = $colors;
        return $this;
    }
    /**
     * Add item to colors value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute $item
     * @return \GraphikDimensions\StructType\Frame
     */
    public function addToColors(\GraphikDimensions\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The colors property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->colors[] = $item;
        return $this;
    }
    /**
     * Get cornerImage value
     * @return string|null
     */
    public function getCornerImage()
    {
        return $this->cornerImage;
    }
    /**
     * Set cornerImage value
     * @param string $cornerImage
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setCornerImage($cornerImage = null)
    {
        // validation for constraint: string
        if (!is_null($cornerImage) && !is_string($cornerImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cornerImage)), __LINE__);
        }
        $this->cornerImage = $cornerImage;
        return $this;
    }
    /**
     * Get loadType value
     * @return string|null
     */
    public function getLoadType()
    {
        return $this->loadType;
    }
    /**
     * Set loadType value
     * @param string $loadType
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setLoadType($loadType = null)
    {
        // validation for constraint: string
        if (!is_null($loadType) && !is_string($loadType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($loadType)), __LINE__);
        }
        $this->loadType = $loadType;
        return $this;
    }
    /**
     * Get material value
     * @return string|null
     */
    public function getMaterial()
    {
        return $this->material;
    }
    /**
     * Set material value
     * @param string $material
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setMaterial($material = null)
    {
        // validation for constraint: string
        if (!is_null($material) && !is_string($material)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($material)), __LINE__);
        }
        $this->material = $material;
        return $this;
    }
    /**
     * Get maxAssembledSize value
     * @return float|null
     */
    public function getMaxAssembledSize()
    {
        return $this->maxAssembledSize;
    }
    /**
     * Set maxAssembledSize value
     * @param float $maxAssembledSize
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setMaxAssembledSize($maxAssembledSize = null)
    {
        $this->maxAssembledSize = $maxAssembledSize;
        return $this;
    }
    /**
     * Get mouldingImageSlice value
     * @return string|null
     */
    public function getMouldingImageSlice()
    {
        return $this->mouldingImageSlice;
    }
    /**
     * Set mouldingImageSlice value
     * @param string $mouldingImageSlice
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setMouldingImageSlice($mouldingImageSlice = null)
    {
        // validation for constraint: string
        if (!is_null($mouldingImageSlice) && !is_string($mouldingImageSlice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mouldingImageSlice)), __LINE__);
        }
        $this->mouldingImageSlice = $mouldingImageSlice;
        return $this;
    }
    /**
     * Get mouldingThickness value
     * @return float|null
     */
    public function getMouldingThickness()
    {
        return $this->mouldingThickness;
    }
    /**
     * Set mouldingThickness value
     * @param float $mouldingThickness
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setMouldingThickness($mouldingThickness = null)
    {
        $this->mouldingThickness = $mouldingThickness;
        return $this;
    }
    /**
     * Get mouldingWidth value
     * @return float|null
     */
    public function getMouldingWidth()
    {
        return $this->mouldingWidth;
    }
    /**
     * Set mouldingWidth value
     * @param float $mouldingWidth
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setMouldingWidth($mouldingWidth = null)
    {
        $this->mouldingWidth = $mouldingWidth;
        return $this;
    }
    /**
     * Get oversizedFee value
     * @return \GraphikDimensions\StructType\OversizedFee|null
     */
    public function getOversizedFee()
    {
        return $this->oversizedFee;
    }
    /**
     * Set oversizedFee value
     * @param \GraphikDimensions\StructType\OversizedFee $oversizedFee
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setOversizedFee(\GraphikDimensions\StructType\OversizedFee $oversizedFee = null)
    {
        $this->oversizedFee = $oversizedFee;
        return $this;
    }
    /**
     * Get profileImage value
     * @return string|null
     */
    public function getProfileImage()
    {
        return $this->profileImage;
    }
    /**
     * Set profileImage value
     * @param string $profileImage
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setProfileImage($profileImage = null)
    {
        // validation for constraint: string
        if (!is_null($profileImage) && !is_string($profileImage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($profileImage)), __LINE__);
        }
        $this->profileImage = $profileImage;
        return $this;
    }
    /**
     * Get rabbetDepth value
     * @return float|null
     */
    public function getRabbetDepth()
    {
        return $this->rabbetDepth;
    }
    /**
     * Set rabbetDepth value
     * @param float $rabbetDepth
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setRabbetDepth($rabbetDepth = null)
    {
        $this->rabbetDepth = $rabbetDepth;
        return $this;
    }
    /**
     * Get rabbetWidth value
     * @return float|null
     */
    public function getRabbetWidth()
    {
        return $this->rabbetWidth;
    }
    /**
     * Set rabbetWidth value
     * @param float $rabbetWidth
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setRabbetWidth($rabbetWidth = null)
    {
        $this->rabbetWidth = $rabbetWidth;
        return $this;
    }
    /**
     * Get readyMadeEquivalent value
     * @return string|null
     */
    public function getReadyMadeEquivalent()
    {
        return $this->readyMadeEquivalent;
    }
    /**
     * Set readyMadeEquivalent value
     * @param string $readyMadeEquivalent
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setReadyMadeEquivalent($readyMadeEquivalent = null)
    {
        // validation for constraint: string
        if (!is_null($readyMadeEquivalent) && !is_string($readyMadeEquivalent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readyMadeEquivalent)), __LINE__);
        }
        $this->readyMadeEquivalent = $readyMadeEquivalent;
        return $this;
    }
    /**
     * Get storeAssemble value
     * @return bool|null
     */
    public function getStoreAssemble()
    {
        return $this->storeAssemble;
    }
    /**
     * Set storeAssemble value
     * @param bool $storeAssemble
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setStoreAssemble($storeAssemble = null)
    {
        $this->storeAssemble = $storeAssemble;
        return $this;
    }
    /**
     * Get styles value
     * @return \GraphikDimensions\StructType\ExternalProductAttribute[]|null
     */
    public function getStyles()
    {
        return $this->styles;
    }
    /**
     * Set styles value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute[] $styles
     * @return \GraphikDimensions\StructType\Frame
     */
    public function setStyles(array $styles = array())
    {
        foreach ($styles as $frameStylesItem) {
            // validation for constraint: itemType
            if (!$frameStylesItem instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
                throw new \InvalidArgumentException(sprintf('The styles property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($frameStylesItem) ? get_class($frameStylesItem) : gettype($frameStylesItem)), __LINE__);
            }
        }
        $this->styles = $styles;
        return $this;
    }
    /**
     * Add item to styles value
     * @throws \InvalidArgumentException
     * @param \GraphikDimensions\StructType\ExternalProductAttribute $item
     * @return \GraphikDimensions\StructType\Frame
     */
    public function addToStyles(\GraphikDimensions\StructType\ExternalProductAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GraphikDimensions\StructType\ExternalProductAttribute) {
            throw new \InvalidArgumentException(sprintf('The styles property can only contain items of \GraphikDimensions\StructType\ExternalProductAttribute, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->styles[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \GraphikDimensions\StructType\Frame
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
