<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for shape EnumType
 * @subpackage Enumerations
 * @Generated by providr
 */
class Shape
{
    /**
     * Constant for value 'OVAL'
     * @return string 'OVAL'
     */
    const VALUE_OVAL = 'OVAL';
    /**
     * Constant for value 'RECTANGLE'
     * @return string 'RECTANGLE'
     */
    const VALUE_RECTANGLE = 'RECTANGLE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OVAL
     * @uses self::VALUE_RECTANGLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OVAL,
            self::VALUE_RECTANGLE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
