<?php

namespace GraphikDimensions;

/**
 * Class which returns the class map definition
 * @package
 */
class ClassMap
{
    /**
     * Returns the mapping between the WSDL Structs and generated Structs' classes
     * This array is sent to the \SoapClient when calling the WS
     * @return string[]
     */
    final public static function get()
    {
        return array(
            'externalOrderStatus' => '\\GraphikDimensions\\StructType\\ExternalOrderStatus',
            'externalOrderConfirmation' => '\\GraphikDimensions\\StructType\\ExternalOrderConfirmation',
            'externalProduct' => '\\GraphikDimensions\\StructType\\ExternalProduct',
            'complexDescription' => '\\GraphikDimensions\\StructType\\ComplexDescription',
            'externalProductAttributeGroup' => '\\GraphikDimensions\\StructType\\ExternalProductAttributeGroup',
            'externalProductAttribute' => '\\GraphikDimensions\\StructType\\ExternalProductAttribute',
            'externalProductGroup' => '\\GraphikDimensions\\StructType\\ExternalProductGroup',
            'externalProductType' => '\\GraphikDimensions\\StructType\\ExternalProductType',
            'externalProductTypeDef' => '\\GraphikDimensions\\StructType\\ExternalProductTypeDef',
            'priceData' => '\\GraphikDimensions\\StructType\\PriceData',
            'externalPromo' => '\\GraphikDimensions\\StructType\\ExternalPromo',
            'externalCriteriaGroup' => '\\GraphikDimensions\\StructType\\ExternalCriteriaGroup',
            'externalCriteria' => '\\GraphikDimensions\\StructType\\ExternalCriteria',
            'externalPriceTable' => '\\GraphikDimensions\\StructType\\ExternalPriceTable',
            'priceMapping' => '\\GraphikDimensions\\StructType\\PriceMapping',
            'sku' => '\\GraphikDimensions\\StructType\\Sku',
            'externalUser' => '\\GraphikDimensions\\StructType\\ExternalUser',
            'dimensionedExternalProduct' => '\\GraphikDimensions\\StructType\\DimensionedExternalProduct',
            'dimension' => '\\GraphikDimensions\\StructType\\Dimension',
            'substrate' => '\\GraphikDimensions\\StructType\\Substrate',
            'acrylic' => '\\GraphikDimensions\\StructType\\Acrylic',
            'aluminum' => '\\GraphikDimensions\\StructType\\Aluminum',
            'canvas' => '\\GraphikDimensions\\StructType\\Canvas',
            'fee' => '\\GraphikDimensions\\StructType\\Fee',
            'assemblyFee' => '\\GraphikDimensions\\StructType\\AssemblyFee',
            'externalProductPackage' => '\\GraphikDimensions\\StructType\\ExternalProductPackage',
            'packagePriceData' => '\\GraphikDimensions\\StructType\\PackagePriceData',
            'framePackage' => '\\GraphikDimensions\\StructType\\FramePackage',
            'backing' => '\\GraphikDimensions\\StructType\\Backing',
            'matBoard' => '\\GraphikDimensions\\StructType\\MatBoard',
            'mat' => '\\GraphikDimensions\\StructType\\Mat',
            'fillet' => '\\GraphikDimensions\\StructType\\Fillet',
            'frame' => '\\GraphikDimensions\\StructType\\Frame',
            'oversizedFee' => '\\GraphikDimensions\\StructType\\OversizedFee',
            'vGroove' => '\\GraphikDimensions\\StructType\\VGroove',
            'board' => '\\GraphikDimensions\\StructType\\Board',
            'finishKit' => '\\GraphikDimensions\\StructType\\FinishKit',
            'finishingOption' => '\\GraphikDimensions\\StructType\\FinishingOption',
            'floatMount' => '\\GraphikDimensions\\StructType\\FloatMount',
            'glazing' => '\\GraphikDimensions\\StructType\\Glazing',
            'image' => '\\GraphikDimensions\\StructType\\Image',
            'externalMedia' => '\\GraphikDimensions\\StructType\\ExternalMedia',
            'printJob' => '\\GraphikDimensions\\StructType\\PrintJob',
            'template' => '\\GraphikDimensions\\StructType\\Template',
            'templateVariable' => '\\GraphikDimensions\\StructType\\TemplateVariable',
            'templateVariableValue' => '\\GraphikDimensions\\StructType\\TemplateVariableValue',
            'liner' => '\\GraphikDimensions\\StructType\\Liner',
            'mountBoard' => '\\GraphikDimensions\\StructType\\MountBoard',
            'nameplate' => '\\GraphikDimensions\\StructType\\Nameplate',
            'raisedMat' => '\\GraphikDimensions\\StructType\\RaisedMat',
            'reverseBevelCut' => '\\GraphikDimensions\\StructType\\ReverseBevelCut',
            'printAndFramePackage' => '\\GraphikDimensions\\StructType\\PrintAndFramePackage',
            'stretcherBar' => '\\GraphikDimensions\\StructType\\StretcherBar',
            'canvasWrapPackage' => '\\GraphikDimensions\\StructType\\CanvasWrapPackage',
            'collection' => '\\GraphikDimensions\\StructType\\Collection',
            'documentPrintJob' => '\\GraphikDimensions\\StructType\\DocumentPrintJob',
            'paper' => '\\GraphikDimensions\\StructType\\Paper',
            'printOnlyPackage' => '\\GraphikDimensions\\StructType\\PrintOnlyPackage',
            'ragMat' => '\\GraphikDimensions\\StructType\\RagMat',
            'paymentMethod' => '\\GraphikDimensions\\StructType\\PaymentMethod',
            'creditCard' => '\\GraphikDimensions\\StructType\\CreditCard',
            'externalAddress' => '\\GraphikDimensions\\StructType\\ExternalAddress',
            'giftCard' => '\\GraphikDimensions\\StructType\\GiftCard',
            'giftData' => '\\GraphikDimensions\\StructType\\GiftData',
            'cash' => '\\GraphikDimensions\\StructType\\Cash',
            'check' => '\\GraphikDimensions\\StructType\\Check',
            'payPal' => '\\GraphikDimensions\\StructType\\PayPal',
            'merchantAccount' => '\\GraphikDimensions\\StructType\\MerchantAccount',
            'giftCertificate' => '\\GraphikDimensions\\StructType\\GiftCertificate',
            'mirror' => '\\GraphikDimensions\\StructType\\Mirror',
            'mirrorPackage' => '\\GraphikDimensions\\StructType\\MirrorPackage',
            'externalPrePackage' => '\\GraphikDimensions\\StructType\\ExternalPrePackage',
            'condorFramePackage' => '\\GraphikDimensions\\StructType\\CondorFramePackage',
            'customProduct' => '\\GraphikDimensions\\StructType\\CustomProduct',
            'boardPackage' => '\\GraphikDimensions\\StructType\\BoardPackage',
            'shadowBoxPackage' => '\\GraphikDimensions\\StructType\\ShadowBoxPackage',
            'moulding' => '\\GraphikDimensions\\StructType\\Moulding',
            'floatMountPackage' => '\\GraphikDimensions\\StructType\\FloatMountPackage',
            'spacer' => '\\GraphikDimensions\\StructType\\Spacer',
            'externalOrder' => '\\GraphikDimensions\\StructType\\ExternalOrder',
            'channelOrderId' => '\\GraphikDimensions\\StructType\\ChannelOrderId',
            'channelSpecificIdentifier' => '\\GraphikDimensions\\StructType\\ChannelSpecificIdentifier',
            'channel' => '\\GraphikDimensions\\StructType\\Channel',
            'costData' => '\\GraphikDimensions\\StructType\\CostData',
            'externalCustomer' => '\\GraphikDimensions\\StructType\\ExternalCustomer',
            'externalOrderLineItem' => '\\GraphikDimensions\\StructType\\ExternalOrderLineItem',
            'channelItemId' => '\\GraphikDimensions\\StructType\\ChannelItemId',
            'shippingData' => '\\GraphikDimensions\\StructType\\ShippingData',
            'internationalShipping' => '\\GraphikDimensions\\StructType\\InternationalShipping',
            'otherUsShipping' => '\\GraphikDimensions\\StructType\\OtherUsShipping',
            'shippingCostData' => '\\GraphikDimensions\\StructType\\ShippingCostData',
            'ServiceException' => '\\GraphikDimensions\\StructType\\ServiceException',
            'getOrderStatus' => '\\GraphikDimensions\\StructType\\GetOrderStatus',
            'getOrderStatusResponse' => '\\GraphikDimensions\\StructType\\GetOrderStatusResponse',
            'introduceExternalObjects' => '\\GraphikDimensions\\StructType\\IntroduceExternalObjects',
            'introduceExternalObjectsResponse' => '\\GraphikDimensions\\StructType\\IntroduceExternalObjectsResponse',
            'processOrder' => '\\GraphikDimensions\\StructType\\ProcessOrder',
            'processOrderResponse' => '\\GraphikDimensions\\StructType\\ProcessOrderResponse',
            'prepareOrder' => '\\GraphikDimensions\\StructType\\PrepareOrder',
            'prepareOrderResponse' => '\\GraphikDimensions\\StructType\\PrepareOrderResponse',
            'addProductToPackage' => '\\GraphikDimensions\\StructType\\AddProductToPackage',
            'addProductToPackageResponse' => '\\GraphikDimensions\\StructType\\AddProductToPackageResponse',
            'setOrderStatus' => '\\GraphikDimensions\\StructType\\SetOrderStatus',
            'setOrderStatusResponse' => '\\GraphikDimensions\\StructType\\SetOrderStatusResponse',
            'validatePaymentMethods' => '\\GraphikDimensions\\StructType\\ValidatePaymentMethods',
            'validatePaymentMethodsResponse' => '\\GraphikDimensions\\StructType\\ValidatePaymentMethodsResponse',
            'createPackage' => '\\GraphikDimensions\\StructType\\CreatePackage',
            'createPackageResponse' => '\\GraphikDimensions\\StructType\\CreatePackageResponse',
            'removeProductFromPackage' => '\\GraphikDimensions\\StructType\\RemoveProductFromPackage',
            'removeProductFromPackageResponse' => '\\GraphikDimensions\\StructType\\RemoveProductFromPackageResponse',
            'createPrePackage' => '\\GraphikDimensions\\StructType\\CreatePrePackage',
            'createPrePackageResponse' => '\\GraphikDimensions\\StructType\\CreatePrePackageResponse',
            'processCoupon' => '\\GraphikDimensions\\StructType\\ProcessCoupon',
            'processCouponResponse' => '\\GraphikDimensions\\StructType\\ProcessCouponResponse',
            'processFramerOrder' => '\\GraphikDimensions\\StructType\\ProcessFramerOrder',
            'processFramerOrderResponse' => '\\GraphikDimensions\\StructType\\ProcessFramerOrderResponse',
            'getOrderByCustomerName' => '\\GraphikDimensions\\StructType\\GetOrderByCustomerName',
            'getOrderByCustomerNameResponse' => '\\GraphikDimensions\\StructType\\GetOrderByCustomerNameResponse',
            'getOrderStatusHistory' => '\\GraphikDimensions\\StructType\\GetOrderStatusHistory',
            'getOrderStatusHistoryResponse' => '\\GraphikDimensions\\StructType\\GetOrderStatusHistoryResponse',
        );
    }
}
