<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for shippingCarriers EnumType
 * @subpackage Enumerations
 * @Generated by providr
 */
class ShippingCarriers
{
    /**
     * Constant for value 'DEFAULT'
     * @return string 'DEFAULT'
     */
    const VALUE_DEFAULT = 'DEFAULT';
    /**
     * Constant for value 'USPS'
     * @return string 'USPS'
     */
    const VALUE_USPS = 'USPS';
    /**
     * Constant for value 'FEDEX'
     * @return string 'FEDEX'
     */
    const VALUE_FEDEX = 'FEDEX';
    /**
     * Constant for value 'UPS'
     * @return string 'UPS'
     */
    const VALUE_UPS = 'UPS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DEFAULT
     * @uses self::VALUE_USPS
     * @uses self::VALUE_FEDEX
     * @uses self::VALUE_UPS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DEFAULT,
            self::VALUE_USPS,
            self::VALUE_FEDEX,
            self::VALUE_UPS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
