<?php

namespace GraphikDimensions\EnumType;

/**
 * This class stands for imageTypes EnumType
 * @subpackage Enumerations
 * @Generated by providr
 */
class ImageTypes
{
    /**
     * Constant for value 'ORIGINAL'
     * @return string 'ORIGINAL'
     */
    const VALUE_ORIGINAL = 'ORIGINAL';
    /**
     * Constant for value 'DIGITAL'
     * @return string 'DIGITAL'
     */
    const VALUE_DIGITAL = 'DIGITAL';
    /**
     * Constant for value 'POSTER'
     * @return string 'POSTER'
     */
    const VALUE_POSTER = 'POSTER';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ORIGINAL
     * @uses self::VALUE_DIGITAL
     * @uses self::VALUE_POSTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ORIGINAL,
            self::VALUE_DIGITAL,
            self::VALUE_POSTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
